/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.collectors.MetricStatus;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsProcessor;
import org.opensearch.performanceanalyzer.commons.metrics.PerformanceAnalyzerMetrics;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;

public class ElectionTermCollector
extends PerformanceAnalyzerMetricsCollector
implements MetricsProcessor {
    public static final int SAMPLING_TIME_INTERVAL = ((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(ElectionTermCollector.class)).samplingInterval;
    private static final Logger LOG = LogManager.getLogger(ElectionTermCollector.class);
    private static final int KEYS_PATH_LENGTH = 0;
    private final ConfigOverridesWrapper configOverridesWrapper;
    private final PerformanceAnalyzerController controller;
    private StringBuilder value = new StringBuilder();

    public ElectionTermCollector(PerformanceAnalyzerController controller, ConfigOverridesWrapper configOverridesWrapper) {
        super(SAMPLING_TIME_INTERVAL, "ElectionTermCollector", (MeasurementSet)StatMetrics.ELECTION_TERM_COLLECTOR_EXECUTION_TIME, StatExceptionCode.ELECTION_TERM_COLLECTOR_ERROR);
        this.controller = controller;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public String getMetricsPath(long startTime, String ... keysPath) {
        if (keysPath.length != 0) {
            throw new RuntimeException("keys length should be 0");
        }
        return PerformanceAnalyzerMetrics.generatePath((long)startTime, (String[])new String[]{"election_term"});
    }

    public void collectMetrics(long startTime) {
        if (!this.controller.isCollectorEnabled(this.configOverridesWrapper, this.getCollectorName())) {
            return;
        }
        if (Objects.isNull(OpenSearchResources.INSTANCE.getClusterService()) || Objects.isNull(OpenSearchResources.INSTANCE.getClusterService().state())) {
            return;
        }
        this.value.setLength(0);
        this.value.append(PerformanceAnalyzerMetrics.getJsonCurrentMilliSeconds()).append(PerformanceAnalyzerMetrics.sMetricNewLineDelimitor);
        this.value.append(new ElectionTermMetrics(OpenSearchResources.INSTANCE.getClusterService().state().term()).serialize());
        this.saveMetricValues(this.value.toString(), startTime, new String[0]);
    }

    public static class ElectionTermMetrics
    extends MetricStatus {
        private final long electionTerm;

        public ElectionTermMetrics(long electionTerm) {
            this.electionTerm = electionTerm;
        }

        @JsonProperty(value="Election_Term")
        public long getElectionTerm() {
            return this.electionTerm;
        }
    }
}

