/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchBackpressureMode;
import org.opensearch.client.opensearch.nodes.stats.ShardSearchBackpressureTaskStats;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardSearchBackpressureStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardSearchBackpressureStats> {
    @Nullable
    private final ShardSearchBackpressureMode mode;
    @Nullable
    private final ShardSearchBackpressureTaskStats searchShardTask;
    @Nullable
    private final ShardSearchBackpressureTaskStats searchTask;
    public static final JsonpDeserializer<ShardSearchBackpressureStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardSearchBackpressureStats::setupShardSearchBackpressureStatsDeserializer);

    private ShardSearchBackpressureStats(Builder builder) {
        this.mode = builder.mode;
        this.searchShardTask = builder.searchShardTask;
        this.searchTask = builder.searchTask;
    }

    public static ShardSearchBackpressureStats of(Function<Builder, ObjectBuilder<ShardSearchBackpressureStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final ShardSearchBackpressureMode mode() {
        return this.mode;
    }

    @Nullable
    public final ShardSearchBackpressureTaskStats searchShardTask() {
        return this.searchShardTask;
    }

    @Nullable
    public final ShardSearchBackpressureTaskStats searchTask() {
        return this.searchTask;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.mode != null) {
            generator.writeKey("mode");
            this.mode.serialize(generator, mapper);
        }
        if (this.searchShardTask != null) {
            generator.writeKey("search_shard_task");
            this.searchShardTask.serialize(generator, mapper);
        }
        if (this.searchTask != null) {
            generator.writeKey("search_task");
            this.searchTask.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardSearchBackpressureStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::mode, ShardSearchBackpressureMode._DESERIALIZER, "mode");
        op.add(Builder::searchShardTask, ShardSearchBackpressureTaskStats._DESERIALIZER, "search_shard_task");
        op.add(Builder::searchTask, ShardSearchBackpressureTaskStats._DESERIALIZER, "search_task");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.mode);
        result = 31 * result + Objects.hashCode(this.searchShardTask);
        result = 31 * result + Objects.hashCode(this.searchTask);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardSearchBackpressureStats other = (ShardSearchBackpressureStats)o;
        return Objects.equals(this.mode, other.mode) && Objects.equals(this.searchShardTask, other.searchShardTask) && Objects.equals(this.searchTask, other.searchTask);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardSearchBackpressureStats> {
        @Nullable
        private ShardSearchBackpressureMode mode;
        @Nullable
        private ShardSearchBackpressureTaskStats searchShardTask;
        @Nullable
        private ShardSearchBackpressureTaskStats searchTask;

        public Builder() {
        }

        private Builder(ShardSearchBackpressureStats o) {
            this.mode = o.mode;
            this.searchShardTask = o.searchShardTask;
            this.searchTask = o.searchTask;
        }

        private Builder(Builder o) {
            this.mode = o.mode;
            this.searchShardTask = o.searchShardTask;
            this.searchTask = o.searchTask;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder mode(@Nullable ShardSearchBackpressureMode value) {
            this.mode = value;
            return this;
        }

        @Nonnull
        public final Builder searchShardTask(@Nullable ShardSearchBackpressureTaskStats value) {
            this.searchShardTask = value;
            return this;
        }

        @Nonnull
        public final Builder searchShardTask(Function<ShardSearchBackpressureTaskStats.Builder, ObjectBuilder<ShardSearchBackpressureTaskStats>> fn) {
            return this.searchShardTask(fn.apply(new ShardSearchBackpressureTaskStats.Builder()).build());
        }

        @Nonnull
        public final Builder searchTask(@Nullable ShardSearchBackpressureTaskStats value) {
            this.searchTask = value;
            return this;
        }

        @Nonnull
        public final Builder searchTask(Function<ShardSearchBackpressureTaskStats.Builder, ObjectBuilder<ShardSearchBackpressureTaskStats>> fn) {
            return this.searchTask(fn.apply(new ShardSearchBackpressureTaskStats.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardSearchBackpressureStats build() {
            this._checkSingleUse();
            return new ShardSearchBackpressureStats(this);
        }
    }
}

