/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenChar;
import org.opensearch.client.opensearch._types.analysis.TokenizerBase;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenizerDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class NGramTokenizer
extends TokenizerBase
implements TokenizerDefinitionVariant,
ToCopyableBuilder<Builder, NGramTokenizer> {
    @Nullable
    private final String customTokenChars;
    private final int maxGram;
    private final int minGram;
    @Nonnull
    private final List<TokenChar> tokenChars;
    public static final JsonpDeserializer<NGramTokenizer> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NGramTokenizer::setupNGramTokenizerDeserializer);

    private NGramTokenizer(Builder builder) {
        super(builder);
        this.customTokenChars = builder.customTokenChars;
        this.maxGram = ApiTypeHelper.requireNonNull(builder.maxGram, this, "maxGram");
        this.minGram = ApiTypeHelper.requireNonNull(builder.minGram, this, "minGram");
        this.tokenChars = ApiTypeHelper.unmodifiableRequired(builder.tokenChars, (Object)this, "tokenChars");
    }

    public static NGramTokenizer of(Function<Builder, ObjectBuilder<NGramTokenizer>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenizerDefinition.Kind _tokenizerDefinitionKind() {
        return TokenizerDefinition.Kind.Ngram;
    }

    @Nullable
    public final String customTokenChars() {
        return this.customTokenChars;
    }

    public final int maxGram() {
        return this.maxGram;
    }

    public final int minGram() {
        return this.minGram;
    }

    @Nonnull
    public final List<TokenChar> tokenChars() {
        return this.tokenChars;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "ngram");
        super.serializeInternal(generator, mapper);
        if (this.customTokenChars != null) {
            generator.writeKey("custom_token_chars");
            generator.write(this.customTokenChars);
        }
        generator.writeKey("max_gram");
        generator.write(this.maxGram);
        generator.writeKey("min_gram");
        generator.write(this.minGram);
        generator.writeKey("token_chars");
        generator.writeStartArray();
        for (TokenChar item0 : this.tokenChars) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupNGramTokenizerDeserializer(ObjectDeserializer<Builder> op) {
        NGramTokenizer.setupTokenizerBaseDeserializer(op);
        op.add(Builder::customTokenChars, JsonpDeserializer.stringDeserializer(), "custom_token_chars");
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram");
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram");
        op.add(Builder::tokenChars, JsonpDeserializer.arrayDeserializer(TokenChar._DESERIALIZER), "token_chars");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.customTokenChars);
        result = 31 * result + Integer.hashCode(this.maxGram);
        result = 31 * result + Integer.hashCode(this.minGram);
        result = 31 * result + this.tokenChars.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NGramTokenizer other = (NGramTokenizer)o;
        return Objects.equals(this.customTokenChars, other.customTokenChars) && this.maxGram == other.maxGram && this.minGram == other.minGram && this.tokenChars.equals(other.tokenChars);
    }

    public static class Builder
    extends TokenizerBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, NGramTokenizer> {
        @Nullable
        private String customTokenChars;
        private Integer maxGram;
        private Integer minGram;
        private List<TokenChar> tokenChars;

        public Builder() {
        }

        private Builder(NGramTokenizer o) {
            super(o);
            this.customTokenChars = o.customTokenChars;
            this.maxGram = o.maxGram;
            this.minGram = o.minGram;
            this.tokenChars = Builder._listCopy(o.tokenChars);
        }

        private Builder(Builder o) {
            super(o);
            this.customTokenChars = o.customTokenChars;
            this.maxGram = o.maxGram;
            this.minGram = o.minGram;
            this.tokenChars = Builder._listCopy(o.tokenChars);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder customTokenChars(@Nullable String value) {
            this.customTokenChars = value;
            return this;
        }

        @Nonnull
        public final Builder maxGram(int value) {
            this.maxGram = value;
            return this;
        }

        @Nonnull
        public final Builder minGram(int value) {
            this.minGram = value;
            return this;
        }

        @Nonnull
        public final Builder tokenChars(List<TokenChar> list) {
            this.tokenChars = Builder._listAddAll(this.tokenChars, list);
            return this;
        }

        @Nonnull
        public final Builder tokenChars(TokenChar value, TokenChar ... values) {
            this.tokenChars = Builder._listAdd(this.tokenChars, value, values);
            return this;
        }

        @Override
        @Nonnull
        public NGramTokenizer build() {
            this._checkSingleUse();
            return new NGramTokenizer(this);
        }
    }
}

