/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.segments;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.segments.Segment;
import org.opensearch.client.opensearch.indices.segments.ShardSegmentRouting;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ShardsSegment
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ShardsSegment> {
    private final int numCommittedSegments;
    private final int numSearchSegments;
    @Nonnull
    private final ShardSegmentRouting routing;
    @Nonnull
    private final Map<String, Segment> segments;
    public static final JsonpDeserializer<ShardsSegment> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ShardsSegment::setupShardsSegmentDeserializer);

    private ShardsSegment(Builder builder) {
        this.numCommittedSegments = ApiTypeHelper.requireNonNull(builder.numCommittedSegments, this, "numCommittedSegments");
        this.numSearchSegments = ApiTypeHelper.requireNonNull(builder.numSearchSegments, this, "numSearchSegments");
        this.routing = ApiTypeHelper.requireNonNull(builder.routing, this, "routing");
        this.segments = ApiTypeHelper.unmodifiableRequired(builder.segments, (Object)this, "segments");
    }

    public static ShardsSegment of(Function<Builder, ObjectBuilder<ShardsSegment>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int numCommittedSegments() {
        return this.numCommittedSegments;
    }

    public final int numSearchSegments() {
        return this.numSearchSegments;
    }

    @Nonnull
    public final ShardSegmentRouting routing() {
        return this.routing;
    }

    @Nonnull
    public final Map<String, Segment> segments() {
        return this.segments;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("num_committed_segments");
        generator.write(this.numCommittedSegments);
        generator.writeKey("num_search_segments");
        generator.write(this.numSearchSegments);
        generator.writeKey("routing");
        this.routing.serialize(generator, mapper);
        generator.writeKey("segments");
        generator.writeStartObject();
        for (Map.Entry<String, Segment> item0 : this.segments.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupShardsSegmentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::numCommittedSegments, JsonpDeserializer.integerDeserializer(), "num_committed_segments");
        op.add(Builder::numSearchSegments, JsonpDeserializer.integerDeserializer(), "num_search_segments");
        op.add(Builder::routing, ShardSegmentRouting._DESERIALIZER, "routing");
        op.add(Builder::segments, JsonpDeserializer.stringMapDeserializer(Segment._DESERIALIZER), "segments");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Integer.hashCode(this.numCommittedSegments);
        result = 31 * result + Integer.hashCode(this.numSearchSegments);
        result = 31 * result + this.routing.hashCode();
        result = 31 * result + this.segments.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardsSegment other = (ShardsSegment)o;
        return this.numCommittedSegments == other.numCommittedSegments && this.numSearchSegments == other.numSearchSegments && this.routing.equals(other.routing) && this.segments.equals(other.segments);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ShardsSegment> {
        private Integer numCommittedSegments;
        private Integer numSearchSegments;
        private ShardSegmentRouting routing;
        private Map<String, Segment> segments;

        public Builder() {
        }

        private Builder(ShardsSegment o) {
            this.numCommittedSegments = o.numCommittedSegments;
            this.numSearchSegments = o.numSearchSegments;
            this.routing = o.routing;
            this.segments = Builder._mapCopy(o.segments);
        }

        private Builder(Builder o) {
            this.numCommittedSegments = o.numCommittedSegments;
            this.numSearchSegments = o.numSearchSegments;
            this.routing = o.routing;
            this.segments = Builder._mapCopy(o.segments);
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder numCommittedSegments(int value) {
            this.numCommittedSegments = value;
            return this;
        }

        @Nonnull
        public final Builder numSearchSegments(int value) {
            this.numSearchSegments = value;
            return this;
        }

        @Nonnull
        public final Builder routing(ShardSegmentRouting value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder routing(Function<ShardSegmentRouting.Builder, ObjectBuilder<ShardSegmentRouting>> fn) {
            return this.routing(fn.apply(new ShardSegmentRouting.Builder()).build());
        }

        @Nonnull
        public final Builder segments(Map<String, Segment> map) {
            this.segments = Builder._mapPutAll(this.segments, map);
            return this;
        }

        @Nonnull
        public final Builder segments(String key, Segment value) {
            this.segments = Builder._mapPut(this.segments, key, value);
            return this;
        }

        @Nonnull
        public final Builder segments(String key, Function<Segment.Builder, ObjectBuilder<Segment>> fn) {
            return this.segments(key, fn.apply(new Segment.Builder()).build());
        }

        @Override
        @Nonnull
        public ShardsSegment build() {
            this._checkSingleUse();
            return new ShardsSegment(this);
        }
    }
}

