/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.jobs.processors;

import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.MLTaskState;
import org.opensearch.ml.common.MLTaskType;
import org.opensearch.ml.common.transport.task.MLTaskGetAction;
import org.opensearch.ml.common.transport.task.MLTaskGetRequest;
import org.opensearch.ml.jobs.processors.MLJobProcessor;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.client.Client;

public class MLBatchTaskUpdateProcessor
extends MLJobProcessor {
    private static final Logger log = LogManager.getLogger(MLBatchTaskUpdateProcessor.class);
    private static MLBatchTaskUpdateProcessor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MLBatchTaskUpdateProcessor getInstance(ClusterService clusterService, Client client, ThreadPool threadPool) {
        if (instance != null) {
            return instance;
        }
        Class<MLBatchTaskUpdateProcessor> clazz = MLBatchTaskUpdateProcessor.class;
        synchronized (MLBatchTaskUpdateProcessor.class) {
            if (instance != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return instance;
            }
            instance = new MLBatchTaskUpdateProcessor(clusterService, client, threadPool);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return instance;
        }
    }

    public static synchronized void reset() {
        instance = null;
    }

    public MLBatchTaskUpdateProcessor(ClusterService clusterService, Client client, ThreadPool threadPool) {
        super(clusterService, client, threadPool);
    }

    @Override
    public void run() {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"task_type", (Object)MLTaskType.BATCH_PREDICTION)).must((QueryBuilder)QueryBuilders.termQuery((String)"function_name", (Object)FunctionName.REMOTE)).must((QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)MLTaskState.RUNNING)).should((QueryBuilder)QueryBuilders.termQuery((String)"state", (Object)MLTaskState.CANCELLING)));
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.size(100);
        sourceBuilder.fetchSource(new String[]{"_id"}, null);
        SearchRequest searchRequest = new SearchRequest(new String[]{".plugins-ml-task"});
        searchRequest.source(sourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            SearchHit[] searchHits;
            if (response == null || response.getHits() == null || response.getHits().getHits().length == 0) {
                log.info("No pending tasks found to be polled by the job");
                return;
            }
            for (SearchHit searchHit : searchHits = response.getHits().getHits()) {
                String taskId = searchHit.getId();
                log.debug("Starting polling for task: {} at {}", (Object)taskId, (Object)Instant.now());
                MLTaskGetRequest mlTaskGetRequest = MLTaskGetRequest.builder().taskId(taskId).isUserInitiatedGetTaskRequest(Boolean.valueOf(false)).build();
                this.client.execute((ActionType)MLTaskGetAction.INSTANCE, (ActionRequest)mlTaskGetRequest, ActionListener.wrap(taskResponse -> log.info("Updated Task status for taskId: {} at {}", (Object)taskId, (Object)Instant.now()), exception -> log.error("Failed to get task status for task: {}", (Object)taskId, exception)));
            }
        }, e -> {
            if (e instanceof IndexNotFoundException) {
                log.info("No tasks found to be polled by the job");
            } else {
                log.error("Failed to search for tasks to be polled by the job ", (Throwable)e);
            }
        }));
    }
}

