/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.training.tracker;

import ai.djl.training.tracker.Tracker;
import ai.djl.util.Preconditions;

public class FactorTracker
implements Tracker {
    private float baseValue;
    private float factor;
    private int maxUpdates;

    public FactorTracker(Builder builder) {
        this.baseValue = builder.baseValue;
        this.factor = builder.factor;
        this.maxUpdates = builder.maxUpdates;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public float getNewValue(int numUpdate) {
        if (numUpdate > this.maxUpdates) {
            numUpdate = this.maxUpdates;
        }
        return (float)((double)this.baseValue * Math.pow(this.factor, numUpdate));
    }

    public static final class Builder {
        private float baseValue;
        private float factor;
        Float min;
        Integer maxUpdates;

        private Builder() {
        }

        public Builder setBaseValue(float baseValue) {
            this.baseValue = baseValue;
            return this;
        }

        public Builder setFactor(float factor) {
            if (factor > 1.0f) {
                throw new IllegalArgumentException("factor should be no more than 1");
            }
            this.factor = factor;
            return this;
        }

        public Builder optMinValue(float min) {
            this.min = Float.valueOf(min);
            return this;
        }

        public Builder optMaxUpdates(int maxUpdates) {
            this.maxUpdates = maxUpdates;
            return this;
        }

        public FactorTracker build() {
            Preconditions.checkArgument(this.factor != 0.0f, "You must set a factor");
            if (this.min != null) {
                Preconditions.checkArgument(this.maxUpdates == null, "You can not set both maxUpdates and a min value");
                Preconditions.checkArgument(this.min.floatValue() < this.baseValue, "The min must be smaller than the base value");
                this.maxUpdates = Math.toIntExact(Math.round(Math.log(this.min.floatValue() / this.baseValue) / Math.log(this.factor)));
            } else if (this.maxUpdates == null) {
                this.maxUpdates = Integer.MAX_VALUE;
            }
            return new FactorTracker(this);
        }
    }
}

