/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.returntypes;

import com.amazon.randomcutforest.CommonUtils;
import java.util.Arrays;

public class RangeVector {
    public final float[] values;
    public final float[] upper;
    public final float[] lower;

    public RangeVector(int dimensions) {
        CommonUtils.checkArgument(dimensions > 0, "dimensions must be greater than 0");
        this.values = new float[dimensions];
        this.upper = new float[dimensions];
        this.lower = new float[dimensions];
    }

    public RangeVector(float[] values, float[] upper, float[] lower) {
        CommonUtils.checkArgument(values.length > 0, " dimensions must be > 0");
        CommonUtils.checkArgument(values.length == upper.length && upper.length == lower.length, "dimensions must be equal");
        this.values = Arrays.copyOf(values, values.length);
        this.upper = Arrays.copyOf(upper, upper.length);
        this.lower = Arrays.copyOf(lower, lower.length);
    }

    public RangeVector(float[] values) {
        CommonUtils.checkArgument(values.length > 0, "dimensions must be > 0 ");
        this.values = Arrays.copyOf(values, values.length);
        this.upper = Arrays.copyOf(values, values.length);
        this.lower = Arrays.copyOf(values, values.length);
    }

    public RangeVector(RangeVector base) {
        int dimensions = base.values.length;
        this.values = Arrays.copyOf(base.values, dimensions);
        this.upper = Arrays.copyOf(base.upper, dimensions);
        this.lower = Arrays.copyOf(base.lower, dimensions);
    }
}

