/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.search.extension;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.util.KNNClusterUtil;
import org.opensearch.search.SearchExtBuilder;
import org.opensearch.search.pipeline.SearchPipelineService;

public class MMRSearchExtBuilder
extends SearchExtBuilder {
    public static final String NAME = "mmr";
    public static final ParseField DIVERSITY_FIELD = new ParseField("diversity", new String[0]);
    public static final ParseField CANDIDATES_FIELD = new ParseField("candidates", new String[0]);
    public static final ParseField VECTOR_FIELD_PATH_FIELD = new ParseField("vector_field_path", new String[0]);
    public static final ParseField VECTOR_FIELD_DATA_TYPE_FIELD = new ParseField("vector_field_data_type", new String[0]);
    public static final ParseField VECTOR_FIELD_SPACE_TYPE_FIELD = new ParseField("vector_field_space_type", new String[0]);
    private Float diversity;
    private Integer candidates;
    private String vectorFieldPath;
    private VectorDataType vectorFieldDataType;
    private SpaceType spaceType;

    public MMRSearchExtBuilder(StreamInput in) throws IOException {
        String spaceTypeStr;
        this.diversity = in.readOptionalFloat();
        this.candidates = in.readOptionalVInt();
        this.vectorFieldPath = in.readOptionalString();
        String vectorFieldDataTypeStr = in.readOptionalString();
        if (vectorFieldDataTypeStr != null) {
            this.vectorFieldDataType = VectorDataType.get(vectorFieldDataTypeStr);
        }
        if ((spaceTypeStr = in.readOptionalString()) != null) {
            this.spaceType = SpaceType.getSpace(spaceTypeStr);
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalFloat(this.diversity);
        out.writeOptionalVInt(this.candidates);
        out.writeOptionalString(this.vectorFieldPath);
        out.writeOptionalString(this.vectorFieldDataType == null ? null : this.vectorFieldDataType.getValue());
        out.writeOptionalString(this.spaceType == null ? null : this.spaceType.getValue());
    }

    public String getWriteableName() {
        return NAME;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        if (this.diversity != null) {
            builder.field(DIVERSITY_FIELD.getPreferredName(), this.diversity);
        }
        if (this.candidates != null) {
            builder.field(CANDIDATES_FIELD.getPreferredName(), this.candidates);
        }
        if (this.vectorFieldPath != null) {
            builder.field(VECTOR_FIELD_PATH_FIELD.getPreferredName(), this.vectorFieldPath);
        }
        if (this.vectorFieldDataType != null) {
            builder.field(VECTOR_FIELD_DATA_TYPE_FIELD.getPreferredName(), this.vectorFieldDataType.getValue());
        }
        if (this.spaceType != null) {
            builder.field(VECTOR_FIELD_SPACE_TYPE_FIELD.getPreferredName(), this.spaceType.getValue());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.diversity, this.candidates, this.vectorFieldPath, this.vectorFieldDataType, this.spaceType});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        MMRSearchExtBuilder other = (MMRSearchExtBuilder)((Object)obj);
        equalsBuilder.append((Object)this.diversity, (Object)other.diversity);
        equalsBuilder.append((Object)this.candidates, (Object)other.candidates);
        equalsBuilder.append((Object)this.vectorFieldPath, (Object)other.vectorFieldPath);
        equalsBuilder.append((Object)this.vectorFieldDataType, (Object)other.vectorFieldDataType);
        equalsBuilder.append((Object)this.spaceType, (Object)other.spaceType);
        return equalsBuilder.isEquals();
    }

    public static MMRSearchExtBuilder parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        MMRSearchExtBuilder.ensureMMRProcessorsEnabled();
        String currentFieldName = "";
        Builder builder = new Builder();
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (DIVERSITY_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.diversity(Float.valueOf(parser.floatValue()));
                    continue;
                }
                if (CANDIDATES_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.candidates(parser.intValue());
                    continue;
                }
                if (VECTOR_FIELD_PATH_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.vectorFieldPath(parser.text());
                    continue;
                }
                if (VECTOR_FIELD_DATA_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.vectorFieldDataType(parser.text());
                    continue;
                }
                if (VECTOR_FIELD_SPACE_TYPE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    builder.spaceType(parser.text());
                    continue;
                }
                throw MMRSearchExtBuilder.unsupportedField(parser, currentFieldName);
            }
            throw MMRSearchExtBuilder.unsupportedField(parser, currentFieldName);
        }
        return builder.build();
    }

    private static void ensureMMRProcessorsEnabled() {
        boolean isMMRProcessorsEnabled;
        List<String> enabledFactories = KNNClusterUtil.instance().getEnabledSystemGeneratedFactories();
        boolean bl = isMMRProcessorsEnabled = enabledFactories.contains("*") || enabledFactories.contains("mmr_over_sample_factory") && enabledFactories.contains("mmr_rerank_factory");
        if (!isMMRProcessorsEnabled) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "We need to enable [%s, %s] in the cluster setting [%s] to support the mmr search extension.", "mmr_over_sample_factory", "mmr_rerank_factory", SearchPipelineService.ENABLED_SYSTEM_GENERATED_FACTORIES_SETTING.getKey()));
        }
    }

    private static ParsingException unsupportedField(XContentParser parser, String fieldName) {
        return new ParsingException(parser.getTokenLocation(), String.format(Locale.ROOT, "[%s] query extension does not support [%s]", NAME, fieldName), new Object[0]);
    }

    @Generated
    private MMRSearchExtBuilder(Float diversity, Integer candidates, String vectorFieldPath, VectorDataType vectorFieldDataType, SpaceType spaceType) {
        this.diversity = diversity;
        this.candidates = candidates;
        this.vectorFieldPath = vectorFieldPath;
        this.vectorFieldDataType = vectorFieldDataType;
        this.spaceType = spaceType;
    }

    @Generated
    public Float getDiversity() {
        return this.diversity;
    }

    @Generated
    public Integer getCandidates() {
        return this.candidates;
    }

    @Generated
    public String getVectorFieldPath() {
        return this.vectorFieldPath;
    }

    @Generated
    public VectorDataType getVectorFieldDataType() {
        return this.vectorFieldDataType;
    }

    @Generated
    public SpaceType getSpaceType() {
        return this.spaceType;
    }

    public static class Builder {
        private Float diversity;
        private Integer candidates;
        private String vectorFieldPath;
        private VectorDataType vectorFieldDataType;
        private SpaceType spaceType;

        public Builder diversity(Float diversity) {
            this.diversity = diversity;
            return this;
        }

        public Builder candidates(Integer candidates) {
            this.candidates = candidates;
            return this;
        }

        public Builder vectorFieldPath(String vectorFieldPath) {
            this.vectorFieldPath = vectorFieldPath;
            return this;
        }

        public Builder vectorFieldDataType(String vectorFieldDataType) {
            try {
                this.vectorFieldDataType = VectorDataType.valueOf(vectorFieldDataType.toUpperCase(Locale.ROOT));
                return this;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s in mmr query extension is not valid, valid values are %s.", VECTOR_FIELD_DATA_TYPE_FIELD.getPreferredName(), VectorDataType.SUPPORTED_VECTOR_DATA_TYPES));
            }
        }

        public Builder spaceType(String spaceType) {
            if (!Arrays.stream(SpaceType.VALID_VALUES).toList().contains(spaceType)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s in mmr query extension is not valid, valid values are %s.", VECTOR_FIELD_SPACE_TYPE_FIELD.getPreferredName(), String.join((CharSequence)",", SpaceType.VALID_VALUES)));
            }
            this.spaceType = SpaceType.getSpace(spaceType);
            return this;
        }

        public MMRSearchExtBuilder build() {
            this.setDefault();
            this.validate();
            return new MMRSearchExtBuilder(this.diversity, this.candidates, this.vectorFieldPath, this.vectorFieldDataType, this.spaceType);
        }

        private void setDefault() {
            if (this.diversity == null) {
                this.diversity = Float.valueOf(0.5f);
            }
        }

        private void validate() {
            if ((double)this.diversity.floatValue() < 0.0 || (double)this.diversity.floatValue() > 1.0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s in mmr query extension must be between 0.0 and 1.0", DIVERSITY_FIELD.getPreferredName()));
            }
            if (this.candidates != null && this.candidates < 0) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s in mmr query extension must be larger than 0.", CANDIDATES_FIELD.getPreferredName()));
            }
            if (this.vectorFieldPath != null && this.vectorFieldPath.isEmpty()) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "%s in mmr query extension should not be an empty string.", VECTOR_FIELD_PATH_FIELD.getPreferredName()));
            }
        }
    }
}

