/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.engine;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.MethodComponentContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.quantization.enums.ScalarQuantizationType;

public class MemoryOptimizedSearchSupportSpec {
    private static final Set<String> SUPPORTED_HNSW_ENCODING = Set.of("flat", "sq", "binary");

    public static boolean isSupportedFieldType(KNNVectorFieldType fieldType, String indexName) {
        if (fieldType.isMemoryOptimizedSearchAvailable()) {
            if (KNNSettings.isMemoryOptimizedKnnSearchModeEnabled(indexName)) {
                return true;
            }
            KNNMappingConfig mappingConfig = fieldType.getKnnMappingConfig();
            return mappingConfig.getMode() == Mode.ON_DISK && mappingConfig.getCompressionLevel() == CompressionLevel.x1;
        }
        return false;
    }

    public static boolean isSupportedFieldType(Optional<KNNMethodContext> methodContextOpt, QuantizationConfig quantizationConfig, Optional<String> modelId) {
        if (modelId.isPresent()) {
            return false;
        }
        if (methodContextOpt.isPresent()) {
            KNNMethodContext methodContext = methodContextOpt.get();
            KNNEngine engine = methodContext.getKnnEngine();
            if (engine == KNNEngine.LUCENE) {
                return true;
            }
            if (engine != KNNEngine.FAISS) {
                return false;
            }
            MethodComponentContext methodComponentContext = methodContext.getMethodComponentContext();
            if (!methodComponentContext.getName().equals("hnsw")) {
                return false;
            }
            if (quantizationConfig != null && quantizationConfig.getQuantizationType() != null && !MemoryOptimizedSearchSupportSpec.isSupportedQuantization(quantizationConfig)) {
                return false;
            }
            Map<String, Object> parameters = methodComponentContext.getParameters();
            Object methodComponentContextObj = parameters.get("encoder");
            if (!(methodComponentContextObj instanceof MethodComponentContext)) {
                return false;
            }
            return SUPPORTED_HNSW_ENCODING.contains(((MethodComponentContext)methodComponentContextObj).getName());
        }
        return false;
    }

    private static boolean isSupportedQuantization(QuantizationConfig quantizationConfig) {
        ScalarQuantizationType quantizationType = quantizationConfig.getQuantizationType();
        return quantizationType == ScalarQuantizationType.ONE_BIT || quantizationType == ScalarQuantizationType.TWO_BIT || quantizationType == ScalarQuantizationType.FOUR_BIT;
    }
}

