/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IpSource {
    AMAZON("amazon"),
    BYOIP("byoip"),
    NONE("none"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IpSource> VALUE_MAP;
    private final String value;

    private IpSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IpSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IpSource> knownValues() {
        EnumSet<IpSource> knownValues = EnumSet.allOf(IpSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IpSource.class, IpSource::toString);
    }
}

