"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlightsSavedObjects = void 0;
var _i18n = require("@osd/i18n");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const layerList = config => [{
  name: 'Default map',
  description: '',
  type: 'opensearch_vector_tile_map',
  id: '15bc3560-700e-479d-b49b-be5ece0451ce',
  zoomRange: [0, 22],
  opacity: 100,
  visibility: 'visible',
  source: {
    dataURL: config.opensearchVectorTileDataUrl
  },
  style: {
    styleURL: config.opensearchVectorTileStyleUrl
  }
}, {
  name: 'Flights On Time',
  description: 'Shows flights that are on time',
  type: 'documents',
  id: '033e870c-4195-48ce-8cc1-e428f0545ce4',
  zoomRange: [0, 6],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'FlightNum', 'Carrier', 'FlightTimeMin'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          FlightDelay: false
        }
      },
      $state: {
        store: 'appState'
      }
    }, {
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          Cancelled: false
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#36f20b',
    borderColor: '#36f20b',
    borderThickness: 1,
    markerSize: 5
  }
}, {
  name: 'Delayed Flights',
  description: 'Shows flights that are having delay',
  type: 'documents',
  id: '7ccae1a8-770d-4565-8c91-6125764fd344',
  zoomRange: [3, 6],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'Carrier', 'FlightDelayMin', 'FlightDelayType'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          FlightDelay: true
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#DA8B45',
    borderColor: '#DA8B45',
    borderThickness: 1,
    markerSize: 5
  }
}, {
  name: 'Cancelled Flights',
  description: 'Shows flights that are cancelled',
  type: 'documents',
  id: '70a61cb4-bea5-4a7b-8f2b-e6debd4334dd',
  zoomRange: [4, 22],
  opacity: 70,
  visibility: 'visible',
  source: {
    indexPatternRefName: 'opensearch_dashboards_sample_data_flights',
    geoFieldType: 'geo_point',
    geoFieldName: 'DestLocation',
    documentRequestNumber: 1000,
    tooltipFields: ['OriginAirportID', 'DestAirportID', 'FlightNum', 'Carrier'],
    showTooltips: true,
    indexPatternId: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
    useGeoBoundingBoxFilter: true,
    filters: [{
      meta: {
        index: 'd3d7af60-4c81-11e8-b3d7-01146121b73d',
        alias: null,
        negate: false,
        disabled: false
      },
      query: {
        match_phrase: {
          Cancelled: true
        }
      },
      $state: {
        store: 'appState'
      }
    }]
  },
  style: {
    fillColor: '#f40a0a',
    borderColor: '#f40a0a',
    borderThickness: 1,
    markerSize: 5
  }
}];
const getFlightsSavedObjects = config => {
  return [{
    id: '88a24e6c-0216-4f76-8bc7-c8db6c8705da',
    type: 'map',
    updated_at: '2023-02-20T03:57:15.482Z',
    version: 'WzIzLDFd',
    migrationVersion: {},
    attributes: {
      title: _i18n.i18n.translate('home.sampleData.flightsSpec.flightsStatusDestinationLocationMaps', {
        defaultMessage: '[Flights] Flights Status on Maps Destination Location'
      }),
      description: 'Sample map that shows flights at destination location that are on time, delayed and cancelled within a given time range.',
      layerList: JSON.stringify(layerList(config)),
      mapState: '{"timeRange":{"from":"now-1w","to":"now"},"query":{"query":"","language":"kuery"},"refreshInterval":{"pause":true,"value":12000}}'
    },
    references: []
  }];
};
exports.getFlightsSavedObjects = getFlightsSavedObjects;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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