"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SvgTextBBoxCalculator = void 0;
var SvgTextBBoxCalculator = (function () {
    function SvgTextBBoxCalculator(rootElement) {
        var xmlns = 'http://www.w3.org/2000/svg';
        this.svgElem = document.createElementNS(xmlns, 'svg');
        this.textElem = document.createElementNS(xmlns, 'text');
        this.svgElem.appendChild(this.textElem);
        this.textNode = document.createTextNode('');
        this.textElem.appendChild(this.textNode);
        this.attachedRoot = rootElement || document.documentElement;
        this.attachedRoot.appendChild(this.svgElem);
    }
    SvgTextBBoxCalculator.prototype.compute = function (text) {
        this.textNode.textContent = text;
        var rect = this.textElem.getBoundingClientRect();
        return {
            width: rect.width,
            height: rect.height,
        };
    };
    SvgTextBBoxCalculator.prototype.destroy = function () {
        this.attachedRoot.removeChild(this.svgElem);
    };
    return SvgTextBBoxCalculator;
}());
exports.SvgTextBBoxCalculator = SvgTextBBoxCalculator;
//# sourceMappingURL=svg_text_bbox_calculator.js.map