/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.caching;

import com.amazon.randomcutforest.parkservices.ThresholdedRandomCutForest;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.timeseries.MemoryTracker;
import org.opensearch.timeseries.caching.CacheBuffer;
import org.opensearch.timeseries.caching.DoorKeeper;
import org.opensearch.timeseries.caching.PriorityTracker;
import org.opensearch.timeseries.caching.TimeSeriesCache;
import org.opensearch.timeseries.common.exception.LimitExceededException;
import org.opensearch.timeseries.common.exception.TimeSeriesException;
import org.opensearch.timeseries.indices.IndexManagement;
import org.opensearch.timeseries.ml.CheckpointDao;
import org.opensearch.timeseries.ml.ModelState;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Entity;
import org.opensearch.timeseries.model.ModelProfile;
import org.opensearch.timeseries.ratelimit.CheckpointMaintainWorker;
import org.opensearch.timeseries.ratelimit.CheckpointWriteWorker;
import org.opensearch.timeseries.util.DateUtils;

public abstract class PriorityCache<RCFModelType extends ThresholdedRandomCutForest, IndexType extends Enum<IndexType>, IndexManagementType extends IndexManagement<IndexType>, CheckpointDaoType extends CheckpointDao<RCFModelType, IndexType, IndexManagementType>, CheckpointWriterType extends CheckpointWriteWorker<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType>, CheckpointMaintainerType extends CheckpointMaintainWorker, CacheBufferType extends CacheBuffer<RCFModelType, IndexType, IndexManagementType, CheckpointDaoType, CheckpointWriterType, CheckpointMaintainerType>>
implements TimeSeriesCache<RCFModelType> {
    private static final Logger LOG = LogManager.getLogger(PriorityCache.class);
    private final Map<String, CacheBufferType> activeEnities;
    private final CheckpointDaoType checkpointDao;
    protected volatile int hcDedicatedCacheSize;
    private Cache<String, ModelState<RCFModelType>> inActiveEntities;
    protected final MemoryTracker memoryTracker;
    private final ReentrantLock maintenanceLock;
    private final int numberOfTrees;
    protected final Clock clock;
    protected final Duration modelTtl;
    private Map<String, DoorKeeper> doorKeepers;
    private ThreadPool threadPool;
    private String threadPoolName;
    private Random random;
    private Instant lastInActiveEntityMaintenance;
    protected int maintenanceFreqConstant;
    protected int checkpointIntervalHrs;
    private MemoryTracker.Origin origin;
    private Map<String, PriorityTracker> priorityTrackerMap;

    public PriorityCache(CheckpointDaoType checkpointDao, int hcDedicatedCacheSize, Setting<TimeValue> checkpointTtl, int maxInactiveStates, MemoryTracker memoryTracker, int numberOfTrees, Clock clock, ClusterService clusterService, Duration modelTtl, ThreadPool threadPool, String threadPoolName, int maintenanceFreqConstant, Settings settings, Setting<TimeValue> checkpointSavingFreq, MemoryTracker.Origin origin, Setting<Integer> dedicatedCacheSizeSetting, Setting<Double> modelMaxSizePercent) {
        this.checkpointDao = checkpointDao;
        this.activeEnities = new ConcurrentHashMap<String, CacheBufferType>();
        this.hcDedicatedCacheSize = hcDedicatedCacheSize;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(dedicatedCacheSizeSetting, it -> {
            this.hcDedicatedCacheSize = it;
            this.setHCDedicatedCacheSizeListener();
            this.tryClearUpMemory();
        }, this::validateDedicatedCacheSize);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(modelMaxSizePercent, it -> this.tryClearUpMemory());
        this.memoryTracker = memoryTracker;
        this.maintenanceLock = new ReentrantLock();
        this.numberOfTrees = numberOfTrees;
        this.clock = clock;
        this.modelTtl = modelTtl;
        this.doorKeepers = new ConcurrentHashMap<String, DoorKeeper>();
        Duration inactiveEntityTtl = DateUtils.toDuration((TimeValue)checkpointTtl.get(settings));
        this.inActiveEntities = this.createInactiveCache(inactiveEntityTtl, maxInactiveStates);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(checkpointTtl, it -> {
            this.inActiveEntities = this.createInactiveCache(DateUtils.toDuration(it), maxInactiveStates);
        });
        this.threadPool = threadPool;
        this.threadPoolName = threadPoolName;
        this.random = new Random(42L);
        this.lastInActiveEntityMaintenance = Instant.MIN;
        this.maintenanceFreqConstant = maintenanceFreqConstant;
        this.checkpointIntervalHrs = DateUtils.toDuration((TimeValue)checkpointSavingFreq.get(settings)).toHoursPart();
        clusterService.getClusterSettings().addSettingsUpdateConsumer(checkpointSavingFreq, it -> {
            this.checkpointIntervalHrs = DateUtils.toDuration(it).toHoursPart();
            this.setCheckpointFreqListener();
        });
        this.origin = origin;
        this.priorityTrackerMap = new ConcurrentHashMap<String, PriorityTracker>();
    }

    @Override
    public ModelState<RCFModelType> get(final String modelId, Config config) {
        final String configId = config.getId();
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.get(configId);
        ModelState modelState = null;
        if (buffer != null) {
            modelState = buffer.get(modelId);
        }
        if (!this.maintenanceLock.isLocked() && modelState == null) {
            DoorKeeper doorKeeper;
            if (this.isDoorKeeperInCacheEnabled() && !(doorKeeper = this.doorKeepers.computeIfAbsent(configId, id -> new DoorKeeper(1000000L, config.getIntervalDuration().multipliedBy(60L), this.clock, 1))).appearsMoreThanOrEqualToThreshold(modelId) && !this.isActive(configId, modelId)) {
                doorKeeper.put(modelId);
                return null;
            }
            try {
                ModelState state = (ModelState)this.inActiveEntities.get((Object)modelId, new Callable<ModelState<RCFModelType>>(){

                    @Override
                    public ModelState<RCFModelType> call() {
                        return PriorityCache.this.createEmptyModelState(modelId, configId);
                    }
                });
                state.setModel(null);
                PriorityTracker tracker = this.priorityTrackerMap.computeIfAbsent(configId, id -> new PriorityTracker(this.clock, config.getIntervalInSeconds(), this.clock.instant().getEpochSecond(), 1000000));
                state.setPriority(tracker.getUpdatedPriority(state.getPriority()));
                if (this.random.nextInt(this.maintenanceFreqConstant) == 1) {
                    this.tryClearUpMemory();
                }
            }
            catch (Exception e) {
                LOG.error((Message)new ParameterizedMessage("Fail to update priority of [{}]", (Object)modelId), (Throwable)e);
            }
        }
        return modelState;
    }

    private Optional<ModelState<RCFModelType>> getStateFromInactiveEntiiyCache(String modelId) {
        if (modelId == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ModelState)this.inActiveEntities.getIfPresent((Object)modelId));
    }

    @Override
    public boolean hostIfPossible(Config config, ModelState<RCFModelType> toUpdate) {
        ModelState<RCFModelType> removed;
        if (toUpdate == null || config.isLongFrequency()) {
            return false;
        }
        String modelId = toUpdate.getModelId();
        String configId = toUpdate.getConfigId();
        if (Strings.isEmpty((CharSequence)modelId) || Strings.isEmpty((CharSequence)configId)) {
            return false;
        }
        CacheBufferType buffer = this.computeBufferIfAbsent(config, configId);
        Optional<ModelState<RCFModelType>> state = this.getStateFromInactiveEntiiyCache(modelId);
        ModelState<RCFModelType> modelState = null;
        modelState = state.isPresent() ? state.get() : this.createEmptyModelState(modelId, configId);
        float priority = modelState.getPriority();
        toUpdate.setPriority(priority);
        if (((CacheBuffer)buffer).dedicatedCacheAvailable() || this.memoryTracker.canAllocate(((CacheBuffer)buffer).getMemoryConsumptionPerModel())) {
            ((CacheBuffer)buffer).put(modelId, toUpdate);
            return true;
        }
        if (this.memoryTracker.canAllocate(((CacheBuffer)buffer).getMemoryConsumptionPerModel())) {
            ((CacheBuffer)buffer).put(modelId, toUpdate);
            return true;
        }
        if (((CacheBuffer)buffer).canReplaceWithinConfig(priority) && (removed = ((CacheBuffer)buffer).replace(modelId, toUpdate)) != null) {
            this.addIntoInactiveCache(removed);
            return true;
        }
        float scaledPriority = ((CacheBuffer)buffer).getPriorityTracker().getScaledPriority(priority);
        Triple<CacheBufferType, String, Float> bufferToRemoveEntity = this.canReplaceInSharedCache(buffer, scaledPriority);
        CacheBuffer bufferToRemove = (CacheBuffer)bufferToRemoveEntity.getLeft();
        String entityModelId = (String)bufferToRemoveEntity.getMiddle();
        ModelState removed2 = null;
        if (bufferToRemove != null && (removed2 = bufferToRemove.remove(entityModelId)) != null) {
            ((CacheBuffer)buffer).put(modelId, toUpdate);
            this.addIntoInactiveCache(removed2);
            return true;
        }
        return false;
    }

    private void addIntoInactiveCache(ModelState<RCFModelType> removed) {
        if (removed == null) {
            return;
        }
        removed.setModel(null);
        this.inActiveEntities.put((Object)removed.getModelId(), removed);
    }

    private void addEntity(List<Entity> destination, Entity entity, String configId) {
        Optional<String> modelId;
        if (entity != null && (modelId = entity.getModelId(configId)).isPresent() && this.inActiveEntities.getIfPresent((Object)modelId.get()) != null) {
            destination.add(entity);
        }
    }

    @Override
    public Pair<List<Entity>, List<Entity>> selectUpdateCandidate(Collection<Entity> cacheMissEntities, String configId, Config config) {
        ArrayList<Entity> hotEntities = new ArrayList<Entity>();
        ArrayList<Entity> coldEntities = new ArrayList<Entity>();
        if (config.isLongFrequency()) {
            return Pair.of(hotEntities, new ArrayList<Entity>(cacheMissEntities));
        }
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.get(configId);
        if (buffer == null) {
            return Pair.of(new ArrayList<Entity>(cacheMissEntities), coldEntities);
        }
        Iterator<Entity> cacheMissEntitiesIter = cacheMissEntities.iterator();
        while (cacheMissEntitiesIter.hasNext() && buffer.dedicatedCacheAvailable()) {
            this.addEntity(hotEntities, cacheMissEntitiesIter.next(), configId);
        }
        while (cacheMissEntitiesIter.hasNext() && this.memoryTracker.canAllocate(buffer.getMemoryConsumptionPerModel())) {
            this.addEntity(hotEntities, cacheMissEntitiesIter.next(), configId);
        }
        ArrayList<Entity> otherBufferReplaceCandidates = new ArrayList<Entity>();
        while (cacheMissEntitiesIter.hasNext()) {
            Optional<ModelState<RCFModelType>> state;
            Entity entity = cacheMissEntitiesIter.next();
            Optional<String> modelId = entity.getModelId(configId);
            if (!modelId.isPresent() || !(state = this.getStateFromInactiveEntiiyCache(modelId.get())).isPresent()) continue;
            ModelState<RCFModelType> modelState = state.get();
            float priority = modelState.getPriority();
            if (buffer.canReplaceWithinConfig(priority)) {
                this.addEntity(hotEntities, entity, configId);
                continue;
            }
            otherBufferReplaceCandidates.add(entity);
        }
        CacheBuffer bufferToRemove = null;
        float minPriority = Float.MIN_VALUE;
        for (Entity entity : otherBufferReplaceCandidates) {
            Optional<ModelState<RCFModelType>> inactiveState;
            Optional<String> modelId = entity.getModelId(configId);
            if (!modelId.isPresent() || !(inactiveState = this.getStateFromInactiveEntiiyCache(modelId.get())).isPresent()) continue;
            ModelState<RCFModelType> state = inactiveState.get();
            float priority = state.getPriority();
            float scaledPriority = buffer.getPriorityTracker().getScaledPriority(priority);
            if (scaledPriority <= minPriority) {
                this.addEntity(coldEntities, entity, configId);
                continue;
            }
            if (minPriority == Float.MIN_VALUE) {
                Triple<CacheBuffer, String, Float> bufferToRemoveEntity = this.canReplaceInSharedCache(buffer, scaledPriority);
                bufferToRemove = (CacheBuffer)bufferToRemoveEntity.getLeft();
                minPriority = ((Float)bufferToRemoveEntity.getRight()).floatValue();
            }
            if (bufferToRemove != null) {
                this.addEntity(hotEntities, entity, configId);
                minPriority = Float.MIN_VALUE;
                continue;
            }
            this.addEntity(coldEntities, entity, configId);
        }
        return Pair.of(hotEntities, coldEntities);
    }

    public CacheBufferType computeBufferIfAbsent(Config config, String configId) {
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.get(configId);
        if (buffer == null) {
            long bytesPerEntityModel = this.getRequiredMemoryPerEntity(config, this.memoryTracker, this.numberOfTrees);
            long requiredBytes = bytesPerEntityModel * (long)(config.isHighCardinality() ? this.hcDedicatedCacheSize : 1);
            if (this.memoryTracker.canAllocateReserved(requiredBytes)) {
                this.memoryTracker.consumeMemory(requiredBytes, true, this.origin);
                buffer = this.createEmptyCacheBuffer(config, bytesPerEntityModel, this.priorityTrackerMap.getOrDefault(configId, new PriorityTracker(this.clock, config.getIntervalInSeconds(), this.clock.instant().getEpochSecond(), 1000000)));
                this.activeEnities.put(configId, buffer);
                this.tryClearUpMemory();
            } else {
                throw new LimitExceededException(configId, "Models memory usage exceeds our limit.");
            }
        }
        return (CacheBufferType)buffer;
    }

    private Triple<CacheBufferType, String, Float> canReplaceInSharedCache(CacheBufferType originBuffer, float candidatePriority) {
        CacheBuffer minPriorityBuffer = null;
        float minPriority = candidatePriority;
        String minPriorityEntityModelId = null;
        for (Map.Entry<String, CacheBufferType> entry : this.activeEnities.entrySet()) {
            float priority;
            Optional<Map.Entry<String, Float>> priorityEntry;
            CacheBuffer buffer = (CacheBuffer)entry.getValue();
            if (buffer == originBuffer || !buffer.canRemove() || !(priorityEntry = buffer.getPriorityTracker().getMinimumScaledPriority()).isPresent() || !(candidatePriority > (priority = priorityEntry.get().getValue().floatValue())) || !(priority < minPriority)) continue;
            minPriority = priority;
            minPriorityBuffer = buffer;
            minPriorityEntityModelId = priorityEntry.get().getKey();
        }
        return Triple.of(minPriorityBuffer, minPriorityEntityModelId, (Object)Float.valueOf(minPriority));
    }

    private void tryClearUpMemory() {
        try {
            if (this.maintenanceLock.tryLock()) {
                this.threadPool.executor(this.threadPoolName).execute(() -> this.clearMemory());
            } else {
                this.threadPool.schedule(() -> {
                    try {
                        this.tryClearUpMemory();
                    }
                    catch (Exception e) {
                        LOG.error("Fail to clear up memory taken by CacheBuffer.  Will retry during maintenance.");
                    }
                }, new TimeValue((long)this.random.nextInt(90), TimeUnit.SECONDS), this.threadPoolName);
            }
        }
        finally {
            if (this.maintenanceLock.isHeldByCurrentThread()) {
                this.maintenanceLock.unlock();
            }
        }
    }

    private void clearMemory() {
        this.recalculateUsedMemory();
        long memoryToShed = this.memoryTracker.memoryToShed();
        PriorityQueue<Triple> removalCandiates = null;
        if (memoryToShed > 0L) {
            removalCandiates = new PriorityQueue<Triple>((x, y) -> Float.compare(((Float)x.getLeft()).floatValue(), ((Float)y.getLeft()).floatValue()));
            for (Map.Entry<String, CacheBufferType> entry : this.activeEnities.entrySet()) {
                CacheBuffer buffer = (CacheBuffer)entry.getValue();
                Optional<Map.Entry<String, Float>> priorityEntry = buffer.getPriorityTracker().getMinimumScaledPriority();
                if (!priorityEntry.isPresent()) continue;
                float priority = priorityEntry.get().getValue().floatValue();
                if (!buffer.canRemove()) continue;
                removalCandiates.add(Triple.of((Object)Float.valueOf(priority), (Object)buffer, (Object)priorityEntry.get().getKey()));
            }
        }
        while (memoryToShed > 0L) {
            if (!removalCandiates.isEmpty()) {
                Optional<Map.Entry<String, Float>> priorityEntry;
                Triple toRemove = (Triple)removalCandiates.poll();
                CacheBuffer minPriorityBuffer = (CacheBuffer)toRemove.getMiddle();
                String minPriorityEntityModelId = (String)toRemove.getRight();
                ModelState removed = minPriorityBuffer.remove(minPriorityEntityModelId);
                memoryToShed -= minPriorityBuffer.getMemoryConsumptionPerModel();
                this.addIntoInactiveCache(removed);
                if (minPriorityBuffer.canRemove() && (priorityEntry = minPriorityBuffer.getPriorityTracker().getMinimumScaledPriority()).isPresent()) {
                    removalCandiates.add(Triple.of((Object)priorityEntry.get().getValue(), (Object)minPriorityBuffer, (Object)priorityEntry.get().getKey()));
                }
            }
            if (!removalCandiates.isEmpty()) continue;
            break;
        }
    }

    private void recalculateUsedMemory() {
        long reserved = 0L;
        long shared = 0L;
        for (Map.Entry<String, CacheBufferType> entry : this.activeEnities.entrySet()) {
            CacheBuffer buffer = (CacheBuffer)entry.getValue();
            reserved += buffer.getReservedBytes();
            shared += buffer.getBytesInSharedCache();
        }
        this.memoryTracker.syncMemoryState(this.origin, reserved + shared, reserved);
    }

    @Override
    public void maintenance() {
        try {
            this.tryClearUpMemory();
            this.activeEnities.entrySet().stream().forEach(cacheBufferEntry -> {
                String configId = (String)cacheBufferEntry.getKey();
                CacheBuffer cacheBuffer = (CacheBuffer)cacheBufferEntry.getValue();
                if (cacheBuffer.expired(this.modelTtl)) {
                    this.activeEnities.remove(configId);
                    cacheBuffer.clear();
                    this.priorityTrackerMap.remove(configId);
                } else {
                    List removedStates = cacheBuffer.maintenance();
                    for (ModelState state : removedStates) {
                        this.addIntoInactiveCache(state);
                    }
                }
            });
            this.maintainInactiveCache();
            this.doorKeepers.entrySet().stream().forEach(doorKeeperEntry -> {
                String configId = (String)doorKeeperEntry.getKey();
                DoorKeeper doorKeeper = (DoorKeeper)doorKeeperEntry.getValue();
                if (doorKeeper.expired(null)) {
                    this.doorKeepers.remove(configId);
                } else {
                    doorKeeper.maintenance();
                }
            });
        }
        catch (Exception e) {
            throw new TimeSeriesException("Fail to maintain cache", e);
        }
    }

    @Override
    public void clear(String configId) {
        if (Strings.isEmpty((CharSequence)configId)) {
            return;
        }
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.remove(configId);
        if (buffer != null) {
            buffer.clear();
        }
        this.priorityTrackerMap.remove(configId);
        ((CheckpointDao)this.checkpointDao).deleteModelCheckpointByConfigId(configId);
        this.doorKeepers.remove(configId);
        this.priorityTrackerMap.remove(configId);
    }

    @Override
    public int getActiveEntities(String detectorId) {
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(detectorId);
        if (cacheBuffer != null) {
            return cacheBuffer.getActiveEntities();
        }
        return 0;
    }

    @Override
    public boolean isActive(String configId, String entityModelId) {
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(configId);
        if (cacheBuffer != null) {
            return cacheBuffer.isActive(entityModelId);
        }
        return false;
    }

    @Override
    public long getTotalUpdates(String configId) {
        if (this.activeEnities == null) {
            return 0L;
        }
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.get(configId);
        if (buffer == null) {
            return 0L;
        }
        PriorityTracker tracker = buffer.getPriorityTracker();
        if (tracker == null) {
            return 0L;
        }
        Optional<String> maybeEntityId = tracker.getHighestPriorityEntityId();
        if (!maybeEntityId.isPresent()) {
            return 0L;
        }
        String entityModelId = maybeEntityId.get();
        long updates = this.getTotalUpdates(configId, entityModelId);
        return updates;
    }

    @Override
    public long getTotalUpdates(String configId, String entityModelId) {
        return Optional.ofNullable((CacheBuffer)this.activeEnities.get(configId)).map(cacheBuffer -> this.getTotalUpdates(cacheBuffer.getModelState(entityModelId))).orElse(0L);
    }

    @Override
    public int getTotalActiveEntities() {
        AtomicInteger total = new AtomicInteger();
        this.activeEnities.values().stream().forEach(cacheBuffer -> total.addAndGet(cacheBuffer.getActiveEntities()));
        return total.get();
    }

    @Override
    public List<ModelState<RCFModelType>> getAllModels() {
        ArrayList states = new ArrayList();
        this.activeEnities.values().stream().forEach(cacheBuffer -> states.addAll(cacheBuffer.getAllModelStates()));
        return states;
    }

    @Override
    public List<ModelState<RCFModelType>> getAllModels(String configId) {
        ArrayList<ModelState<RCFModelType>> states = new ArrayList<ModelState<RCFModelType>>();
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(configId);
        if (cacheBuffer != null) {
            states.addAll(cacheBuffer.getAllModelStates());
        }
        return states;
    }

    @Override
    public Map<String, Long> getModelSize(String configId) {
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(configId);
        HashMap<String, Long> res = new HashMap<String, Long>();
        if (cacheBuffer != null) {
            long size = cacheBuffer.getMemoryConsumptionPerModel();
            cacheBuffer.getAllModelStates().forEach(entry -> res.put(entry.getModelId(), size));
        }
        return res;
    }

    @Override
    public long getLastActiveTime(String detectorId, String entityModelId) {
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(detectorId);
        long lastUsedMs = -1L;
        if (cacheBuffer != null && (lastUsedMs = cacheBuffer.getLastUsedTime(entityModelId)) != -1L) {
            return lastUsedMs;
        }
        ModelState stateInActive = (ModelState)this.inActiveEntities.getIfPresent((Object)entityModelId);
        if (stateInActive != null) {
            lastUsedMs = stateInActive.getLastUsedTime().toEpochMilli();
        }
        return lastUsedMs;
    }

    @Override
    public void releaseMemoryForOpenCircuitBreaker() {
        this.maintainInactiveCache();
        this.tryClearUpMemory();
        this.activeEnities.values().stream().forEach(cacheBuffer -> {
            if (cacheBuffer.canRemove()) {
                ModelState removed = cacheBuffer.remove();
                this.addIntoInactiveCache(removed);
            }
        });
    }

    private void maintainInactiveCache() {
        if (this.lastInActiveEntityMaintenance.plus(this.modelTtl).isAfter(this.clock.instant())) {
            return;
        }
        this.inActiveEntities.cleanUp();
        for (ModelState state : this.inActiveEntities.asMap().values()) {
            Optional modelOptional = state.getModel();
            if (!modelOptional.isPresent()) continue;
            LOG.warn((Message)new ParameterizedMessage("Inactive entity's model is null: [{}]. Maybe there are bugs.", (Object)state.getModelId()));
            state.setModel(null);
        }
        this.lastInActiveEntityMaintenance = this.clock.instant();
    }

    private void setHCDedicatedCacheSizeListener() {
        this.activeEnities.values().stream().forEach(cacheBuffer -> cacheBuffer.setMinimumCapacity(this.hcDedicatedCacheSize));
    }

    private void setCheckpointFreqListener() {
        this.activeEnities.values().stream().forEach(cacheBuffer -> cacheBuffer.setCheckpointIntervalHrs(this.checkpointIntervalHrs));
    }

    @Override
    public List<ModelProfile> getAllModelProfile(String detectorId) {
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(detectorId);
        if (cacheBuffer != null) {
            long size = cacheBuffer.getMemoryConsumptionPerModel();
            return cacheBuffer.getAllModelStates().stream().map(entry -> new ModelProfile(entry.getModelId(), entry.getEntity().orElse(null), size)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<ModelProfile> getModelProfile(String detectorId, String entityModelId) {
        CacheBuffer cacheBuffer = (CacheBuffer)this.activeEnities.get(detectorId);
        if (cacheBuffer != null && cacheBuffer.getModelState(entityModelId) != null) {
            ModelState modelState = cacheBuffer.getModelState(entityModelId);
            Entity entity = null;
            if (modelState != null && modelState.getEntity().isPresent()) {
                entity = modelState.getEntity().get();
            }
            return Optional.of(new ModelProfile(entityModelId, entity, cacheBuffer.getMemoryConsumptionPerModel()));
        }
        return Optional.empty();
    }

    private void validateDedicatedCacheSize(Integer newDedicatedCacheSize) {
        if (this.hcDedicatedCacheSize < newDedicatedCacheSize) {
            int delta = newDedicatedCacheSize - this.hcDedicatedCacheSize;
            long totalIncreasedBytes = 0L;
            for (CacheBuffer cacheBuffer : this.activeEnities.values()) {
                totalIncreasedBytes += cacheBuffer.getMemoryConsumptionPerModel() * (long)delta;
            }
            if (!this.memoryTracker.canAllocateReserved(totalIncreasedBytes)) {
                throw new IllegalArgumentException("We don't have enough memory for the required change");
            }
        }
    }

    @Override
    public Optional<ModelState<RCFModelType>> getForMaintainance(String configId, String modelId) {
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.get(configId);
        if (buffer == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(buffer.getWithoutUpdatePriority(modelId));
    }

    @Override
    public void removeModel(String configId, String modelId) {
        ModelState removed;
        CacheBuffer buffer = (CacheBuffer)this.activeEnities.get(configId);
        if (buffer != null && (removed = buffer.remove(modelId, false)) != null) {
            this.addIntoInactiveCache(removed);
        }
        ((CheckpointDao)this.checkpointDao).deleteModelCheckpoint(modelId, (ActionListener<Void>)ActionListener.wrap(r -> LOG.debug((Message)new ParameterizedMessage("Succeeded in deleting checkpoint [{}].", (Object)modelId)), e -> LOG.error((Message)new ParameterizedMessage("Failed to delete checkpoint [{}].", (Object)modelId), (Throwable)e)));
    }

    private Cache<String, ModelState<RCFModelType>> createInactiveCache(Duration inactiveEntityTtl, int maxInactiveStates) {
        return CacheBuilder.newBuilder().expireAfterAccess(inactiveEntityTtl.toHours(), TimeUnit.HOURS).maximumSize((long)maxInactiveStates).concurrencyLevel(1).build();
    }

    protected abstract ModelState<RCFModelType> createEmptyModelState(String var1, String var2);

    protected abstract CacheBufferType createEmptyCacheBuffer(Config var1, long var2, PriorityTracker var4);

    protected abstract boolean isDoorKeeperInCacheEnabled();
}

