/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.warmer;

import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.metrics.CounterMetric;
import org.opensearch.common.metrics.MeanMetric;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.shard.AbstractIndexShardComponent;
import org.opensearch.index.warmer.WarmerStats;

@PublicApi(since="1.0.0")
public class ShardIndexWarmerService
extends AbstractIndexShardComponent {
    private final CounterMetric current = new CounterMetric();
    private final MeanMetric warmerMetric = new MeanMetric();

    public ShardIndexWarmerService(ShardId shardId, IndexSettings indexSettings) {
        super(shardId, indexSettings);
    }

    public Logger logger() {
        return this.logger;
    }

    public void onPreWarm() {
        this.current.inc();
    }

    public void onPostWarm(long tookInNanos) {
        this.current.dec();
        this.warmerMetric.inc(tookInNanos);
    }

    public WarmerStats stats() {
        return new WarmerStats.Builder().current(this.current.count()).total(this.warmerMetric.count()).totalTimeInMillis(TimeUnit.NANOSECONDS.toMillis(this.warmerMetric.sum())).build();
    }
}

