/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.Version;
import org.opensearch.action.admin.indices.stats.CommonStats;
import org.opensearch.action.admin.indices.stats.IndexShardStats;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.action.search.SearchRequestStats;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.cache.query.QueryCacheStats;
import org.opensearch.index.cache.request.RequestCacheStats;
import org.opensearch.index.engine.SegmentsStats;
import org.opensearch.index.fielddata.FieldDataStats;
import org.opensearch.index.flush.FlushStats;
import org.opensearch.index.get.GetStats;
import org.opensearch.index.merge.MergeStats;
import org.opensearch.index.recovery.RecoveryStats;
import org.opensearch.index.refresh.RefreshStats;
import org.opensearch.index.search.stats.SearchStats;
import org.opensearch.index.shard.DocsStats;
import org.opensearch.index.shard.IndexingStats;
import org.opensearch.index.store.StoreStats;
import org.opensearch.index.translog.TranslogStats;
import org.opensearch.index.warmer.WarmerStats;
import org.opensearch.search.suggest.completion.CompletionStats;

@PublicApi(since="1.0.0")
public class NodeIndicesStats
implements Writeable,
ToXContentFragment {
    protected CommonStats stats;
    protected Map<Index, CommonStats> statsByIndex;
    protected Map<Index, List<IndexShardStats>> statsByShard;

    public NodeIndicesStats(StreamInput in) throws IOException {
        this.stats = new CommonStats(in);
        if (in.getVersion().onOrAfter(Version.V_2_17_0) && in.readBoolean()) {
            this.statsByIndex = this.readStatsByIndex(in);
        }
        if (in.readBoolean()) {
            this.statsByShard = this.readStatsByShard(in);
        }
    }

    public NodeIndicesStats(CommonStats oldStats, Map<Index, List<IndexShardStats>> statsByShard, SearchRequestStats searchRequestStats) {
        this.statsByShard = statsByShard;
        this.stats = oldStats;
        for (List<IndexShardStats> shardStatsList : statsByShard.values()) {
            for (IndexShardStats indexShardStats : shardStatsList) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    this.stats.add(shardStats.getStats());
                }
            }
        }
        if (this.stats.search != null) {
            this.stats.search.setSearchRequestStats(searchRequestStats);
        }
    }

    public NodeIndicesStats(CommonStats oldStats, Map<Index, List<IndexShardStats>> statsByShard, SearchRequestStats searchRequestStats, StatsLevel level) {
        this.stats = oldStats;
        for (List<IndexShardStats> shardStatsList : statsByShard.values()) {
            for (IndexShardStats indexShardStats : shardStatsList) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    this.stats.add(shardStats.getStats());
                }
            }
        }
        if (this.stats.search != null) {
            this.stats.search.setSearchRequestStats(searchRequestStats);
        }
        if (level != null) {
            switch (level.ordinal()) {
                case 0: {
                    this.statsByIndex = this.createStatsByIndex(statsByShard);
                    break;
                }
                case 1: {
                    this.statsByShard = statsByShard;
                }
            }
        }
    }

    public static StatsLevel getAcceptedLevel(String[] levels) {
        if (levels != null && levels.length > 0) {
            Optional<StatsLevel> level = Arrays.stream(StatsLevel.values()).filter(field -> field.getRestName().equals(levels[0])).findFirst();
            return level.orElseThrow(() -> new IllegalArgumentException("Level provided is not supported by NodeIndicesStats"));
        }
        return null;
    }

    private Map<Index, CommonStats> readStatsByIndex(StreamInput in) throws IOException {
        HashMap<Index, CommonStats> statsByIndex = new HashMap<Index, CommonStats>();
        int indexEntries = in.readVInt();
        for (int i = 0; i < indexEntries; ++i) {
            Index index = new Index(in);
            CommonStats commonStats = new CommonStats(in);
            statsByIndex.put(index, commonStats);
        }
        return statsByIndex;
    }

    private Map<Index, List<IndexShardStats>> readStatsByShard(StreamInput in) throws IOException {
        HashMap<Index, List<IndexShardStats>> statsByShard = new HashMap<Index, List<IndexShardStats>>();
        int entries = in.readVInt();
        for (int i = 0; i < entries; ++i) {
            Index index = new Index(in);
            int indexShardListSize = in.readVInt();
            ArrayList<IndexShardStats> indexShardStats = new ArrayList<IndexShardStats>(indexShardListSize);
            for (int j = 0; j < indexShardListSize; ++j) {
                indexShardStats.add(new IndexShardStats(in));
            }
            statsByShard.put(index, indexShardStats);
        }
        return statsByShard;
    }

    @Nullable
    public StoreStats getStore() {
        return this.stats.getStore();
    }

    @Nullable
    public DocsStats getDocs() {
        return this.stats.getDocs();
    }

    @Nullable
    public IndexingStats getIndexing() {
        return this.stats.getIndexing();
    }

    @Nullable
    public GetStats getGet() {
        return this.stats.getGet();
    }

    @Nullable
    public SearchStats getSearch() {
        return this.stats.getSearch();
    }

    @Nullable
    public MergeStats getMerge() {
        return this.stats.getMerge();
    }

    @Nullable
    public RefreshStats getRefresh() {
        return this.stats.getRefresh();
    }

    @Nullable
    public FlushStats getFlush() {
        return this.stats.getFlush();
    }

    @Nullable
    public WarmerStats getWarmer() {
        return this.stats.getWarmer();
    }

    @Nullable
    public FieldDataStats getFieldData() {
        return this.stats.getFieldData();
    }

    @Nullable
    public QueryCacheStats getQueryCache() {
        return this.stats.getQueryCache();
    }

    @Nullable
    public RequestCacheStats getRequestCache() {
        return this.stats.getRequestCache();
    }

    @Nullable
    public CompletionStats getCompletion() {
        return this.stats.getCompletion();
    }

    @Nullable
    public SegmentsStats getSegments() {
        return this.stats.getSegments();
    }

    @Nullable
    public TranslogStats getTranslog() {
        return this.stats.getTranslog();
    }

    @Nullable
    public RecoveryStats getRecoveryStats() {
        return this.stats.getRecoveryStats();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.stats.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_2_17_0)) {
            out.writeBoolean(this.statsByIndex != null);
            if (this.statsByIndex != null) {
                this.writeStatsByIndex(out);
            }
        }
        out.writeBoolean(this.statsByShard != null);
        if (this.statsByShard != null) {
            this.writeStatsByShards(out);
        }
    }

    private void writeStatsByIndex(StreamOutput out) throws IOException {
        if (this.statsByIndex != null) {
            out.writeVInt(this.statsByIndex.size());
            for (Map.Entry<Index, CommonStats> entry : this.statsByIndex.entrySet()) {
                entry.getKey().writeTo(out);
                entry.getValue().writeTo(out);
            }
        }
    }

    private void writeStatsByShards(StreamOutput out) throws IOException {
        if (this.statsByShard != null) {
            out.writeVInt(this.statsByShard.size());
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                entry.getKey().writeTo(out);
                out.writeVInt(entry.getValue().size());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    indexShardStats.writeTo(out);
                }
            }
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean isLevelValid;
        String level = params.param("level", StatsLevel.NODE.getRestName());
        boolean bl = isLevelValid = StatsLevel.NODE.getRestName().equalsIgnoreCase(level) || StatsLevel.INDICES.getRestName().equalsIgnoreCase(level) || StatsLevel.SHARDS.getRestName().equalsIgnoreCase(level);
        if (!isLevelValid) {
            throw new IllegalArgumentException("level parameter must be one of [" + StatsLevel.INDICES.getRestName() + "] or [" + StatsLevel.NODE.getRestName() + "] or [" + StatsLevel.SHARDS.getRestName() + "] but was [" + level + "]");
        }
        builder.startObject(StatsLevel.INDICES.getRestName());
        this.stats.toXContent(builder, params);
        if (StatsLevel.INDICES.getRestName().equals(level)) {
            assert (this.statsByIndex != null || this.statsByShard != null) : "Expected shard stats or index stats in response for generating [" + String.valueOf((Object)StatsLevel.INDICES) + "] field";
            if (this.statsByIndex == null) {
                this.statsByIndex = this.createStatsByIndex(this.statsByShard);
            }
            builder.startObject(StatsLevel.INDICES.getRestName());
            for (Map.Entry<Index, CommonStats> entry : this.statsByIndex.entrySet()) {
                builder.startObject(entry.getKey().getName());
                entry.getValue().toXContent(builder, params);
                builder.endObject();
            }
            builder.endObject();
        } else if (StatsLevel.SHARDS.getRestName().equals(level)) {
            builder.startObject(StatsLevel.SHARDS.getRestName());
            assert (this.statsByShard != null) : "Expected shard stats in response for generating [" + String.valueOf((Object)StatsLevel.SHARDS) + "] field";
            for (Map.Entry<Index, List<IndexShardStats>> entry : this.statsByShard.entrySet()) {
                builder.startArray(entry.getKey().getName());
                for (IndexShardStats indexShardStats : entry.getValue()) {
                    builder.startObject().startObject(String.valueOf(indexShardStats.getShardId().getId()));
                    for (ShardStats shardStats : indexShardStats.getShards()) {
                        shardStats.toXContent(builder, params);
                    }
                    builder.endObject().endObject();
                }
                builder.endArray();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    private Map<Index, CommonStats> createStatsByIndex(Map<Index, List<IndexShardStats>> statsByShard) {
        HashMap<Index, CommonStats> statsMap = new HashMap<Index, CommonStats>();
        for (Map.Entry<Index, List<IndexShardStats>> entry : statsByShard.entrySet()) {
            if (!statsMap.containsKey(entry.getKey())) {
                statsMap.put(entry.getKey(), new CommonStats());
            }
            for (IndexShardStats indexShardStats : entry.getValue()) {
                for (ShardStats shardStats : indexShardStats.getShards()) {
                    ((CommonStats)statsMap.get(entry.getKey())).add(shardStats.getStats());
                }
            }
        }
        return statsMap;
    }

    public List<IndexShardStats> getShardStats(Index index) {
        if (this.statsByShard == null) {
            return null;
        }
        return this.statsByShard.get(index);
    }

    @PublicApi(since="3.0.0")
    public static enum StatsLevel {
        INDICES("indices"),
        SHARDS("shards"),
        NODE("node");

        private final String restName;

        private StatsLevel(String restName) {
            this.restName = restName;
        }

        public String getRestName() {
            return this.restName;
        }
    }
}

