/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.remote.filecache;

import java.io.IOException;
import org.opensearch.common.annotation.InternalApi;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentFragment;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.index.store.remote.filecache.AggregateFileCacheStats;

@PublicApi(since="2.7.0")
public class FileCacheStats
implements Writeable,
ToXContentFragment {
    private final long active;
    private final long total;
    private final long used;
    private final long pinned;
    private final long evicted;
    private final long hits;
    private final long misses;
    private final AggregateFileCacheStats.FileCacheStatsType statsType;

    @InternalApi
    public FileCacheStats(long active, long total, long used, long pinned, long evicted, long hits, long misses, AggregateFileCacheStats.FileCacheStatsType statsType) {
        this.active = active;
        this.total = total;
        this.used = used;
        this.pinned = pinned;
        this.evicted = evicted;
        this.hits = hits;
        this.misses = misses;
        this.statsType = statsType;
    }

    @InternalApi
    public FileCacheStats(StreamInput in) throws IOException {
        this.statsType = AggregateFileCacheStats.FileCacheStatsType.fromString(in.readString());
        this.active = in.readLong();
        this.total = in.readLong();
        this.used = in.readLong();
        this.pinned = in.readLong();
        this.evicted = in.readLong();
        this.hits = in.readLong();
        this.misses = in.readLong();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.statsType.toString());
        out.writeLong(this.active);
        out.writeLong(this.total);
        out.writeLong(this.used);
        out.writeLong(this.pinned);
        out.writeLong(this.evicted);
        out.writeLong(this.hits);
        out.writeLong(this.misses);
    }

    public long getActive() {
        return this.active;
    }

    public long getUsed() {
        return this.used;
    }

    public long getEvicted() {
        return this.evicted;
    }

    public long getHits() {
        return this.hits;
    }

    public short getActivePercent() {
        return AggregateFileCacheStats.calculatePercentage(this.active, this.used);
    }

    public long getTotal() {
        return this.total;
    }

    public long getPinnedUsage() {
        return this.pinned;
    }

    public short getUsedPercent() {
        return AggregateFileCacheStats.calculatePercentage(this.getUsed(), this.total);
    }

    public long getCacheHits() {
        return this.hits;
    }

    public long getCacheMisses() {
        return this.misses;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.statsType.toString());
        builder.humanReadableField("active_in_bytes", "active", (Object)new ByteSizeValue(this.getActive()));
        builder.humanReadableField("used_in_bytes", "used", (Object)new ByteSizeValue(this.getUsed()));
        builder.humanReadableField("used_in_bytes", "pinned", (Object)new ByteSizeValue(this.getPinnedUsage()));
        builder.humanReadableField("evictions_in_bytes", "evictions", (Object)new ByteSizeValue(this.getEvicted()));
        builder.field("active_percent", this.getActivePercent());
        builder.field("hit_count", this.getHits());
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String ACTIVE = "active";
        static final String ACTIVE_IN_BYTES = "active_in_bytes";
        static final String USED = "used";
        static final String PINNED = "pinned";
        static final String USED_IN_BYTES = "used_in_bytes";
        static final String EVICTIONS = "evictions";
        static final String EVICTIONS_IN_BYTES = "evictions_in_bytes";
        static final String ACTIVE_PERCENT = "active_percent";
        static final String HIT_COUNT = "hit_count";

        Fields() {
        }
    }
}

