/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster;

import java.util.function.Predicate;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.node.DiscoveryNode;

public final class ClusterManagerNodeChangePredicate {
    private ClusterManagerNodeChangePredicate() {
    }

    public static Predicate<ClusterState> build(ClusterState currentState) {
        long currentVersion = currentState.version();
        DiscoveryNode clusterManagerNode = currentState.nodes().getClusterManagerNode();
        String currentMasterId = clusterManagerNode == null ? null : clusterManagerNode.getEphemeralId();
        return newState -> {
            DiscoveryNode newClusterManager = newState.nodes().getClusterManagerNode();
            boolean accept = newClusterManager == null ? false : (!newClusterManager.getEphemeralId().equals(currentMasterId) ? true : newState.version() > currentVersion);
            return accept;
        };
    }
}

