/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.bootstrap;

import java.io.FilePermission;
import java.io.IOException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.opensearch.bootstrap.Security;
import org.opensearch.common.SuppressForbidden;

final class OpenSearchPolicy
extends Policy {
    static final String POLICY_RESOURCE = "security.policy";
    static final String UNTRUSTED_RESOURCE = "untrusted.policy";
    final Policy template;
    final Policy untrusted;
    final Policy system;
    final PermissionCollection dynamic;
    final PermissionCollection dataPathPermission;
    final Map<String, Policy> plugins;
    private static final Permission BAD_DEFAULT_NUMBER_ONE = new BadDefaultPermission(new RuntimePermission("stopThread"), p -> true);
    private static final Permission BAD_DEFAULT_NUMBER_TWO = new BadDefaultPermission(new SocketPermission("localhost:0", "listen"), p -> p instanceof SocketPermission && p.getActions().contains("listen"));

    OpenSearchPolicy(Map<String, URL> codebases, PermissionCollection dynamic, Map<String, Policy> plugins, boolean filterBadDefaults, PermissionCollection dataPathPermission) {
        this.template = Security.readPolicy(this.getClass().getResource(POLICY_RESOURCE), codebases);
        this.dataPathPermission = dataPathPermission;
        this.untrusted = Security.readPolicy(this.getClass().getResource(UNTRUSTED_RESOURCE), Collections.emptyMap());
        this.system = filterBadDefaults ? new SystemPolicy(Policy.getPolicy()) : Policy.getPolicy();
        this.dynamic = dynamic;
        this.plugins = plugins;
    }

    @Override
    @SuppressForbidden(reason="fast equals check is desired")
    public boolean implies(ProtectionDomain domain, Permission permission) {
        CodeSource codeSource = domain.getCodeSource();
        if (codeSource == null) {
            return false;
        }
        URL location = codeSource.getLocation();
        if (location != null) {
            if ("/untrusted".equals(location.getFile())) {
                return this.untrusted.implies(domain, permission);
            }
            Policy plugin = this.plugins.get(location.getFile());
            if (plugin != null && plugin.implies(domain, permission)) {
                return true;
            }
        }
        if (permission instanceof FilePermission && "<<ALL FILES>>".equals(permission.getName())) {
            for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
                if (!"org.apache.hadoop.util.Shell".equals(element.getClassName()) || !"runCommand".equals(element.getMethodName())) continue;
                this.rethrow(new IOException("no hadoop, you cannot do this."));
            }
        }
        if (permission instanceof FilePermission && this.dataPathPermission.implies(permission)) {
            return true;
        }
        return this.template.implies(domain, permission) || this.dynamic.implies(permission) || this.system.implies(domain, permission);
    }

    private void rethrow(Throwable t) {
        new Rethrower().rethrow(t);
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!"sun.rmi.server.LoaderHandler".equals(element.getClassName()) || !"loadClass".equals(element.getMethodName())) continue;
            return new Permissions();
        }
        return super.getPermissions(codesource);
    }

    static class SystemPolicy
    extends Policy {
        final Policy delegate;

        SystemPolicy(Policy delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean implies(ProtectionDomain domain, Permission permission) {
            if (BAD_DEFAULT_NUMBER_ONE.implies(permission) || BAD_DEFAULT_NUMBER_TWO.implies(permission)) {
                return false;
            }
            return this.delegate.implies(domain, permission);
        }
    }

    private static class Rethrower<T extends Throwable> {
        private Rethrower() {
        }

        private void rethrow(Throwable t) throws T {
            throw t;
        }
    }

    private static class BadDefaultPermission
    extends Permission {
        private final Permission badDefaultPermission;
        private final Predicate<Permission> preImplies;

        BadDefaultPermission(Permission badDefaultPermission, Predicate<Permission> preImplies) {
            super(badDefaultPermission.getName());
            this.badDefaultPermission = badDefaultPermission;
            this.preImplies = preImplies;
        }

        @Override
        public final boolean implies(Permission permission) {
            return this.preImplies.test(permission) && this.badDefaultPermission.implies(permission);
        }

        @Override
        public final boolean equals(Object obj) {
            return this.badDefaultPermission.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.badDefaultPermission.hashCode();
        }

        @Override
        public String getActions() {
            return this.badDefaultPermission.getActions();
        }
    }
}

