/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.admin.cluster.repositories.put;

import java.io.IOException;
import org.opensearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.action.support.clustermanager.TransportClusterManagerNodeAction;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.block.ClusterBlockException;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportService;

public class TransportPutRepositoryAction
extends TransportClusterManagerNodeAction<PutRepositoryRequest, AcknowledgedResponse> {
    private final RepositoriesService repositoriesService;

    @Inject
    public TransportPutRepositoryAction(TransportService transportService, ClusterService clusterService, RepositoriesService repositoriesService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/repository/put", transportService, clusterService, threadPool, actionFilters, PutRepositoryRequest::new, indexNameExpressionResolver);
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(PutRepositoryRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    @Override
    protected void clusterManagerOperation(PutRepositoryRequest request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        this.repositoriesService.registerOrUpdateRepository(request, (ActionListener<ClusterStateUpdateResponse>)ActionListener.delegateFailure(listener, (delegatedListener, response) -> delegatedListener.onResponse((Object)new AcknowledgedResponse(response.isAcknowledged()))));
    }
}

