/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.jcajce.spec.HybridValueParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPPad;
import org.bouncycastle.openpgp.operator.PublicKeyKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.RFC6637Utils;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcePublicKeyKeyEncryptionMethodGenerator
extends PublicKeyKeyEncryptionMethodGenerator {
    private static final byte X_HDR = 64;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private SecureRandom random;
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcePublicKeyKeyEncryptionMethodGenerator(PGPPublicKey key) {
        super(key);
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.keyConverter.setProvider(providerName);
        return this;
    }

    public JcePublicKeyKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    protected byte[] encryptSessionInfo(PGPPublicKey pubKey, byte[] sessionKey, byte optSymAlgId, boolean isV3) throws PGPException {
        try {
            PublicKey cryptoPublicKey = this.keyConverter.getPublicKey(pubKey);
            if (pubKey.getAlgorithm() == 18) {
                byte[] sessionInfo = this.createSessionInfo(isV3 ? optSymAlgId : (byte)0, sessionKey);
                final ECDHPublicBCPGKey ecKey = (ECDHPublicBCPGKey)pubKey.getPublicKeyPacket().getKey();
                String keyEncryptionOID = RFC6637Utils.getKeyEncryptionOID(ecKey.getSymmetricKeyAlgorithm()).getId();
                PublicKeyPacket pubKeyPacket = pubKey.getPublicKeyPacket();
                if (JcaJcePGPUtil.isX25519(ecKey.getCurveOID())) {
                    return this.encryptSessionInfoWithECDHKey(this.getKeyPair("X25519", 255), pubKeyPacket, cryptoPublicKey, keyEncryptionOID, ecKey.getSymmetricKeyAlgorithm(), sessionInfo, RFC6637Utils.getXDHAlgorithm(pubKeyPacket), optSymAlgId, new EphPubEncoding(){

                        @Override
                        public byte[] getEphPubEncoding(byte[] publicKeyData) {
                            return Arrays.prepend((byte[])publicKeyData, (byte)64);
                        }
                    });
                }
                if (ecKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
                    return this.encryptSessionInfoWithECDHKey(this.getKeyPair("X448", 448), pubKeyPacket, cryptoPublicKey, keyEncryptionOID, ecKey.getSymmetricKeyAlgorithm(), sessionInfo, RFC6637Utils.getXDHAlgorithm(pubKeyPacket), optSymAlgId, new EphPubEncoding(){

                        @Override
                        public byte[] getEphPubEncoding(byte[] publicKeyData) {
                            return Arrays.prepend((byte[])publicKeyData, (byte)64);
                        }
                    });
                }
                KeyPairGenerator kpGen = this.helper.createKeyPairGenerator("EC");
                AlgorithmParameters ecAlgParams = this.helper.createAlgorithmParameters("EC");
                ecAlgParams.init(new X962Parameters(ecKey.getCurveOID()).getEncoded());
                kpGen.initialize(ecAlgParams.getParameterSpec(AlgorithmParameterSpec.class), this.random);
                KeyPair ephKP = kpGen.generateKeyPair();
                return this.encryptSessionInfoWithECDHKey(ephKP, pubKeyPacket, cryptoPublicKey, keyEncryptionOID, ecKey.getSymmetricKeyAlgorithm(), sessionInfo, RFC6637Utils.getAgreementAlgorithm(pubKeyPacket), optSymAlgId, new EphPubEncoding(){

                    @Override
                    public byte[] getEphPubEncoding(byte[] ephPubEncoding) {
                        if (null == ephPubEncoding || ephPubEncoding.length < 1 || ephPubEncoding[0] != 4) {
                            ephPubEncoding = JcaJcePGPUtil.getX9Parameters(ecKey.getCurveOID()).getCurve().decodePoint(ephPubEncoding).getEncoded(false);
                        }
                        return ephPubEncoding;
                    }
                });
            }
            if (pubKey.getAlgorithm() == 25) {
                return this.encryptSessionInfoWithX25519X448Key(pubKey, "X25519", cryptoPublicKey, NISTObjectIdentifiers.id_aes128_wrap.getId(), 7, sessionKey, "X25519withSHA256HKDF", 255, optSymAlgId, isV3);
            }
            if (pubKey.getAlgorithm() == 26) {
                return this.encryptSessionInfoWithX25519X448Key(pubKey, "X448", cryptoPublicKey, NISTObjectIdentifiers.id_aes256_wrap.getId(), 9, sessionKey, "X448withSHA512HKDF", 448, optSymAlgId, isV3);
            }
            Cipher c = this.helper.createPublicKeyCipher(pubKey.getAlgorithm());
            c.init(3, (Key)cryptoPublicKey, this.random);
            byte[] sessionInfo = this.createSessionInfo(isV3 ? optSymAlgId : (byte)0, sessionKey);
            return c.wrap(new SecretKeySpec(sessionInfo, "SESSION"));
        }
        catch (IllegalBlockSizeException e) {
            throw new PGPException("illegal block size: " + e.getMessage(), e);
        }
        catch (BadPaddingException e) {
            throw new PGPException("bad padding: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new PGPException("key invalid: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new PGPException("unable to encode MPI: " + e.getMessage(), e);
        }
        catch (GeneralSecurityException e) {
            throw new PGPException("unable to set up ephemeral keys: " + e.getMessage(), e);
        }
    }

    private byte[] encryptSessionInfoWithECDHKey(KeyPair ephKP, PublicKeyPacket pubKeyPacket, PublicKey cryptoPublicKey, String keyEncryptionOID, int symmetricKeyAlgorithm, byte[] sessionInfo, String agreementName, byte symAlgId, EphPubEncoding getEncoding) throws GeneralSecurityException, IOException, PGPException {
        UserKeyingMaterialSpec ukmSpec = new UserKeyingMaterialSpec(RFC6637Utils.createUserKeyingMaterial(pubKeyPacket, new JcaKeyFingerprintCalculator()));
        Key secret = JcaJcePGPUtil.getSecret(this.helper, cryptoPublicKey, keyEncryptionOID, agreementName, (AlgorithmParameterSpec)ukmSpec, ephKP.getPrivate());
        byte[] ephPubEncoding = getEncoding.getEphPubEncoding(SubjectPublicKeyInfo.getInstance((Object)ephKP.getPublic().getEncoded()).getPublicKeyData().getBytes());
        byte[] paddedSessionData = PGPPad.padSessionData(sessionInfo, this.sessionKeyObfuscation);
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(new MPInteger(new BigInteger(1, ephPubEncoding)).getEncoded(), (byte)0, this.getWrapper(symmetricKeyAlgorithm, symAlgId, secret, paddedSessionData));
    }

    private byte[] encryptSessionInfoWithX25519X448Key(PGPPublicKey pgpPublicKey, String algorithmName, PublicKey cryptoPublicKey, String keyEncryptionOID, int symmetricKeyAlgorithm, byte[] sessionKey, String agreementAlgorithmName, int keySize, byte optSymAlgId, boolean isV3) throws GeneralSecurityException, IOException, PGPException {
        KeyPair ephKP = this.getKeyPair(algorithmName, keySize);
        byte[] ephPubEncoding = SubjectPublicKeyInfo.getInstance((Object)ephKP.getPublic().getEncoded()).getPublicKeyData().getBytes();
        HybridValueParameterSpec ukmSpec = JcaJcePGPUtil.getHybridValueParameterSpecWithPrepend(ephPubEncoding, pgpPublicKey.getPublicKeyPacket(), algorithmName);
        Key secret = JcaJcePGPUtil.getSecret(this.helper, cryptoPublicKey, keyEncryptionOID, agreementAlgorithmName, (AlgorithmParameterSpec)ukmSpec, ephKP.getPrivate());
        return JcePublicKeyKeyEncryptionMethodGenerator.getSessionInfo(ephPubEncoding, isV3 ? optSymAlgId : (byte)0, this.getWrapper(symmetricKeyAlgorithm, optSymAlgId, secret, sessionKey));
    }

    private KeyPair getKeyPair(String algorithmName, int keySize) throws GeneralSecurityException {
        KeyPairGenerator kpGen = this.helper.createKeyPairGenerator(algorithmName);
        kpGen.initialize(keySize, this.random);
        return kpGen.generateKeyPair();
    }

    private byte[] getWrapper(int symmetricKeyAlgorithm, byte optSymAlgId, Key secret, byte[] sessionData) throws PGPException, InvalidKeyException, IllegalBlockSizeException {
        Cipher c = this.helper.createKeyWrapper(symmetricKeyAlgorithm);
        c.init(3, secret, this.random);
        return c.wrap(new SecretKeySpec(sessionData, PGPUtil.getSymmetricCipherName(optSymAlgId)));
    }

    @FunctionalInterface
    private static interface EphPubEncoding {
        public byte[] getEphPubEncoding(byte[] var1);
    }
}

