/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.math.ec.ECPoint;

public abstract class ECPublicBCPGKey
extends BCPGObject
implements BCPGKey {
    ASN1ObjectIdentifier oid;
    BigInteger point;

    protected ECPublicBCPGKey(BCPGInputStream in) throws IOException {
        this.oid = ASN1ObjectIdentifier.getInstance((Object)ASN1Primitive.fromByteArray((byte[])ECPublicBCPGKey.readBytesOfEncodedLength(in)));
        this.point = new MPInteger(in).getValue();
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier oid, ECPoint point) {
        this.point = new BigInteger(1, point.getEncoded(false));
        this.oid = oid;
    }

    protected ECPublicBCPGKey(ASN1ObjectIdentifier oid, BigInteger encodedPoint) {
        this.point = encodedPoint;
        this.oid = oid;
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        byte[] oid = this.oid.getEncoded();
        out.write(oid, 1, oid.length - 1);
        MPInteger point = new MPInteger(this.point);
        out.writeObject(point);
    }

    public BigInteger getEncodedPoint() {
        return this.point;
    }

    public ASN1ObjectIdentifier getCurveOID() {
        return this.oid;
    }

    protected static byte[] readBytesOfEncodedLength(BCPGInputStream in) throws IOException {
        int length = in.read();
        if (length < 0) {
            throw new IOException("unexpected end-of-stream");
        }
        if (length == 0 || length == 255) {
            throw new IOException("future extensions not yet implemented");
        }
        if (length > 127) {
            throw new IOException("unsupported OID");
        }
        byte[] buffer = new byte[length + 2];
        in.readFully(buffer, 2, buffer.length - 2);
        buffer[0] = 6;
        buffer[1] = (byte)length;
        return buffer;
    }
}

