/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.inject.spi;

import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.inject.Binder;
import org.opensearch.common.inject.TypeLiteral;
import org.opensearch.common.inject.matcher.Matcher;
import org.opensearch.common.inject.spi.Element;
import org.opensearch.common.inject.spi.ElementVisitor;
import org.opensearch.common.inject.spi.TypeListener;

@PublicApi(since="1.0.0")
public final class TypeListenerBinding
implements Element {
    private final Object source;
    private final Matcher<? super TypeLiteral<?>> typeMatcher;
    private final TypeListener listener;

    TypeListenerBinding(Object source, TypeListener listener, Matcher<? super TypeLiteral<?>> typeMatcher) {
        this.source = source;
        this.listener = listener;
        this.typeMatcher = typeMatcher;
    }

    public TypeListener getListener() {
        return this.listener;
    }

    public Matcher<? super TypeLiteral<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public <T> T acceptVisitor(ElementVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void applyTo(Binder binder) {
        binder.withSource(this.getSource()).bindListener(this.typeMatcher, this.listener);
    }
}

