/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import oracle.ucp.common.ServiceMember;

class InstanceSet {
    static final InstanceSet EMPTY = new InstanceSet();
    private final ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock rLock = this.rwLock.readLock();
    private final ReentrantReadWriteLock.WriteLock wLock = this.rwLock.writeLock();
    private final Set<ServiceMember> instanceSet = new HashSet<ServiceMember>();
    private final AtomicReference<Set<ServiceMember>> instanceSetSnapshot = new AtomicReference<Set<ServiceMember>>(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.instanceSet)));

    InstanceSet() {
    }

    void add(ServiceMember instance) {
        if (null == instance) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instanceSet.add(instance);
            this.instanceSetSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.instanceSet)));
        }
        finally {
            this.wLock.unlock();
        }
    }

    void remove(ServiceMember instance) {
        if (null == instance) {
            throw new IllegalArgumentException();
        }
        this.wLock.lock();
        try {
            this.instanceSet.remove(instance);
            this.instanceSetSnapshot.set(Collections.unmodifiableSet(new HashSet<ServiceMember>(this.instanceSet)));
        }
        finally {
            this.wLock.unlock();
        }
    }

    Set<ServiceMember> allInstances() {
        return this.instanceSetSnapshot.get();
    }
}

