/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.compare;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.openapitools.openapidiff.core.compare.CacheKey;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;
import org.openapitools.openapidiff.core.model.deferred.RealizedChanged;

public abstract class ReferenceDiffCache<C, D extends Changed> {
    private final Map<CacheKey, DeferredChanged<D>> refDiffMap = new HashMap<CacheKey, DeferredChanged<D>>();

    private DeferredChanged<D> getFromCache(CacheKey cacheKey) {
        return this.refDiffMap.get(cacheKey);
    }

    private void addToCache(CacheKey cacheKey, DeferredChanged<D> changed) {
        this.refDiffMap.put(cacheKey, changed);
    }

    public DeferredChanged<D> cachedDiff(HashSet<String> refSet, C left, C right, String leftRef, String rightRef, DiffContext context) {
        boolean areBothRefParameters;
        boolean bl = areBothRefParameters = leftRef != null && rightRef != null;
        if (areBothRefParameters) {
            CacheKey key = new CacheKey(leftRef, rightRef, context);
            DeferredChanged<D> changedFromRef = this.getFromCache(key);
            if (changedFromRef != null) {
                return changedFromRef;
            }
            String refKey = this.getRefKey(leftRef, rightRef);
            if (refSet.contains(refKey)) {
                return RealizedChanged.empty();
            }
            refSet.add(refKey);
            DeferredChanged<D> changed = this.computeDiff(refSet, left, right, context);
            this.addToCache(key, changed);
            refSet.remove(refKey);
            return changed;
        }
        return this.computeDiff(refSet, left, right, context);
    }

    protected String getRefKey(String leftRef, String rightRef) {
        return leftRef + ":" + rightRef;
    }

    protected abstract DeferredChanged<D> computeDiff(HashSet<String> var1, C var2, C var3, DiffContext var4);
}

