# -*- coding: binary -*-

module Msf
  module Exploit::Remote::SMB
    # This mixin provides a minimal SMB server
    module Server
      include ::Msf::Exploit::Remote::SocketServer
      include ::Msf::Exploit::Remote::SMB::LogAdapter

      def initialize(info = {})
        super

        register_options(
          [
            OptPort.new('SRVPORT', [ true, 'The local port to listen on.', 445 ])
          ], self.class)
      end

      def start_service(opts = {})
        unless opts[:logger]
          log_device = LogAdapter::LogDevice::Framework.new(framework)
          opts[:logger] = LogAdapter::Logger.new(self, log_device)
        end

        self.service = Rex::ServiceManager.start(
          Rex::Proto::SMB::Server,
          (opts['ServerPort'] || bindport).to_i,
          opts['ServerHost'] || bindhost,
          {
            'Msf'        => framework,
            'MsfExploit' => self,
          },
          opts['Comm'] || _determine_server_comm(opts['ServerHost'] || bindhost),
          gss_provider: opts[:gss_provider],
          logger: opts[:logger]
        )

        service.on_client_connect_proc = Proc.new { |client|
          on_client_connect(client)
        }

        print_status("Server is running. Listening on #{bindhost}:#{bindport}")
      end

      def on_client_connect(client)
        vprint_status("Received SMB connection from #{client.peerhost}")
      end
    end
  end
end

