/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.tabs.tab_film;

import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import mediathek.gui.actions.DeleteBookmarksAction;
import mediathek.gui.actions.ManageBookmarkAction;
import mediathek.gui.actions.PlayFilmAction;
import mediathek.gui.tabs.tab_film.GuiFilme;
import mediathek.gui.tabs.tab_film.filter_selection.FilterSelectionComboBox;
import mediathek.gui.tabs.tab_film.filter_selection.FilterSelectionComboBoxModel;
import mediathek.swing.IconOnlyButton;
import mediathek.swing.IconOnlyToggleButton;
import mediathek.tool.ApplicationConfiguration;
import org.jetbrains.annotations.NotNull;

public class FilmToolBar
extends JToolBar {
    private final JLabel lblSearch = new JLabel("Suche:");
    private final FilterSelectionComboBox filterSelectionComboBox;
    private final GuiFilme.SearchField searchField;
    private final GuiFilme.ToggleFilterDialogVisibilityAction toggleFilterDialogVisibilityAction;
    private final FilterVisibilityToggleButton btnToggleFilterDialogVisibility;

    public FilmToolBar(@NotNull FilterSelectionComboBoxModel filterModel, @NotNull GuiFilme.BookmarkAddFilmAction bookmarkAddFilmAction, @NotNull GuiFilme.BookmarkRemoveFilmAction bookmarkRemoveFilmAction, @NotNull DeleteBookmarksAction bookmarkClearListAction, @NotNull ManageBookmarkAction manageBookmarkAction, @NotNull PlayFilmAction playFilmAction, @NotNull GuiFilme.SaveFilmAction saveFilmAction, @NotNull GuiFilme.SearchField searchField, @NotNull GuiFilme.ToggleFilterDialogVisibilityAction toggleFilterDialogVisibilityAction) {
        this.searchField = searchField;
        this.toggleFilterDialogVisibilityAction = toggleFilterDialogVisibilityAction;
        this.btnToggleFilterDialogVisibility = new FilterVisibilityToggleButton(toggleFilterDialogVisibilityAction);
        this.add(new IconOnlyButton(playFilmAction));
        this.add(new IconOnlyButton(saveFilmAction));
        this.addSeparator();
        this.filterSelectionComboBox = new FilterSelectionComboBox(filterModel);
        this.add(this.filterSelectionComboBox);
        this.addSeparator();
        this.add(this.lblSearch);
        this.add(searchField);
        this.addSeparator();
        this.add(this.btnToggleFilterDialogVisibility);
        this.addSeparator();
        this.add(new IconOnlyButton(bookmarkAddFilmAction));
        this.add(new IconOnlyButton(bookmarkRemoveFilmAction));
        this.addSeparator();
        this.add(new IconOnlyButton(bookmarkClearListAction));
        this.addSeparator();
        this.add(new IconOnlyButton(manageBookmarkAction));
    }

    public FilterVisibilityToggleButton getToggleFilterDialogVisibilityButton() {
        return this.btnToggleFilterDialogVisibility;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.lblSearch.setEnabled(enabled);
        this.searchField.setEnabled(enabled);
        this.filterSelectionComboBox.setEnabled(enabled);
        this.toggleFilterDialogVisibilityAction.setEnabled(enabled);
    }

    public static class FilterVisibilityToggleButton
    extends IconOnlyToggleButton {
        public FilterVisibilityToggleButton(Action a) {
            super(a);
            boolean visible = ApplicationConfiguration.getConfiguration().getBoolean("application.ui.filter_dialog.visible", false);
            this.setSelected(visible);
        }
    }
}

