/*
 * Decompiled with CFR 0.152.
 */
package mediathek.filmlisten;

import javax.swing.event.EventListenerList;
import mediathek.daten.ListeFilme;
import mediathek.filmeSuchen.ListenerFilmeLaden;
import mediathek.filmeSuchen.ListenerFilmeLadenEvent;
import mediathek.filmlisten.FilmeImportierenAutoThread;
import mediathek.filmlisten.reader.FilmListReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ImportFilmliste {
    private static final Logger logger = LogManager.getLogger(ImportFilmliste.class);
    private final EventListenerList listeners = new EventListenerList();
    private final FilmListReader msFilmListReader = new FilmListReader();

    public ImportFilmliste() {
        this.msFilmListReader.addAdListener(new ListenerFilmeLaden(){

            @Override
            public synchronized void start(ListenerFilmeLadenEvent event) {
                for (ListenerFilmeLaden l : (ListenerFilmeLaden[])ImportFilmliste.this.listeners.getListeners(ListenerFilmeLaden.class)) {
                    l.start(event);
                }
            }

            @Override
            public synchronized void progress(ListenerFilmeLadenEvent event) {
                for (ListenerFilmeLaden l : (ListenerFilmeLaden[])ImportFilmliste.this.listeners.getListeners(ListenerFilmeLaden.class)) {
                    l.progress(event);
                }
            }
        });
    }

    public void importFromUrl(ListeFilme listeFilme, ListeFilme listeFilmeDiff, int days) {
        FilmeImportierenAutoThread importThread = new FilmeImportierenAutoThread(listeFilme, listeFilmeDiff, days, this::urlLaden, this::fertigMelden);
        importThread.start();
    }

    public void importFromFile(String pfad, ListeFilme listeFilme, int days) {
        Thread t = new Thread(() -> {
            boolean result2 = this.urlLaden(pfad, listeFilme, days);
            this.fertigMelden(result2);
        });
        t.start();
    }

    public void addAdListener(ListenerFilmeLaden listener) {
        this.listeners.add(ListenerFilmeLaden.class, listener);
    }

    private boolean urlLaden(String dateiUrl, ListeFilme listeFilme, int days) {
        boolean ret = false;
        try {
            if (!dateiUrl.isEmpty()) {
                logger.trace("Filmliste laden von: {}", (Object)dateiUrl);
                this.msFilmListReader.readFilmListe(dateiUrl, listeFilme, days);
                if (!listeFilme.isEmpty()) {
                    ret = true;
                }
            }
        }
        catch (Exception ex) {
            logger.error("urlLaden", (Throwable)ex);
        }
        return ret;
    }

    private synchronized void fertigMelden(boolean ok) {
        for (ListenerFilmeLaden l : (ListenerFilmeLaden[])this.listeners.getListeners(ListenerFilmeLaden.class)) {
            l.fertig(new ListenerFilmeLadenEvent("", "", 0, 0, !ok));
        }
    }
}

