import { Redis } from 'ioredis';
import { IrcClientState, WhoisResponse, IrcCapabilities, IrcSupported, ChanData } from 'matrix-org-irc';
interface ChanDataDehydrated {
    created?: string;
    key: string;
    serverName: string;
    /**
     * nick => mode
     */
    users: [string, string][];
    mode: string;
    modeParams: [string, string[]][];
    topic?: string;
    topicBy?: string;
}
export interface IrcClientStateDehydrated {
    loggedIn: boolean;
    registered: boolean;
    /**
    * This will either be the requested nick or the actual nickname.
    */
    currentNick: string;
    whoisData: [string, WhoisResponse][];
    nickMod: number;
    modeForPrefix: {
        [prefix: string]: string;
    };
    capabilities: ReturnType<IrcCapabilities["serialise"]>;
    supportedState?: IrcSupported;
    hostMask: string;
    chans?: [string, ChanDataDehydrated][];
    prefixForMode: {
        [mode: string]: string;
    };
    maxLineLength: number;
    lastSendTime: number;
}
export declare class IrcClientRedisState implements IrcClientState {
    private readonly redis;
    private readonly clientId;
    private readonly innerState;
    private putStatePromise;
    static create(redis: Redis, clientId: string, freshState: boolean): Promise<IrcClientRedisState>;
    private constructor();
    get loggedIn(): boolean;
    set loggedIn(value: boolean);
    get registered(): boolean;
    set registered(value: boolean);
    get currentNick(): string;
    set currentNick(value: string);
    get whoisData(): Map<string, WhoisResponse>;
    set whoisData(value: Map<string, WhoisResponse>);
    get nickMod(): number;
    set nickMod(value: number);
    get modeForPrefix(): {
        [prefix: string]: string;
    };
    set modeForPrefix(value: {
        [prefix: string]: string;
    });
    get capabilities(): IrcCapabilities;
    set capabilities(value: IrcCapabilities);
    get supportedState(): IrcSupported;
    set supportedState(value: IrcSupported);
    get hostMask(): string;
    set hostMask(value: string);
    get chans(): Map<string, ChanData>;
    set chans(value: Map<string, ChanData>);
    get prefixForMode(): {
        [mode: string]: string;
    };
    set prefixForMode(value: {
        [mode: string]: string;
    });
    get lastSendTime(): number;
    set lastSendTime(value: number);
    flush(): void;
    private innerPutState;
}
export {};
