/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.load.java.lazy.descriptors.JavaDescriptorUtilKt;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\r*\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\r0\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmPropertyVsFieldAmbiguityCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "selfOrBaseForFakeOverride", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "predicate", "Lkotlin/Function1;", "frontend.java"})
@SourceDebugExtension(value={"SMAP\nJvmPropertyVsFieldAmbiguityCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmPropertyVsFieldAmbiguityCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmPropertyVsFieldAmbiguityCallChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n1869#2,2:89\n1761#2,3:91\n*S KotlinDebug\n*F\n+ 1 JvmPropertyVsFieldAmbiguityCallChecker.kt\norg/jetbrains/kotlin/resolve/jvm/checkers/JvmPropertyVsFieldAmbiguityCallChecker\n*L\n39#1:89,2\n86#1:91,3\n*E\n"})
public final class JvmPropertyVsFieldAmbiguityCallChecker
implements CallChecker {
    @NotNull
    public static final JvmPropertyVsFieldAmbiguityCallChecker INSTANCE = new JvmPropertyVsFieldAmbiguityCallChecker();

    private JvmPropertyVsFieldAmbiguityCallChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        void $this$forEach$iv;
        ClassDescriptor fieldClassDescriptor;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (!context2.getLanguageVersionSettings().supportsFeature(LanguageFeature.PreferJavaFieldOverload)) {
            return;
        }
        Object obj = resolvedCall2.getResultingDescriptor();
        PropertyDescriptor propertyDescriptor = obj instanceof PropertyDescriptor ? (PropertyDescriptor)obj : null;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor resultingDescriptor = propertyDescriptor;
        if (!JavaDescriptorUtilKt.isJavaField(resultingDescriptor)) {
            return;
        }
        DeclarationDescriptor declarationDescriptor = resultingDescriptor.getContainingDeclaration();
        ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
        if (classDescriptor == null) {
            return;
        }
        ClassDescriptor ownContainingClass = classDescriptor;
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.unwrapFakeOverride((CallableMemberDescriptor)resultingDescriptor);
        Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor, "unwrapFakeOverride(...)");
        PropertyDescriptor field = (PropertyDescriptor)callableMemberDescriptor;
        Object object = field.getContainingDeclaration();
        ClassDescriptor classDescriptor2 = fieldClassDescriptor = object instanceof ClassDescriptor ? (ClassDescriptor)object : null;
        if (fieldClassDescriptor == ownContainingClass) {
            return;
        }
        MemberScope memberScope2 = ownContainingClass.getUnsubstitutedMemberScope();
        Name name2 = resultingDescriptor.getName();
        Intrinsics.checkNotNullExpressionValue(name2, "getName(...)");
        object = memberScope2.getContributedVariables(name2, NoLookupLocation.FOR_ALREADY_TRACKED);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object object2;
            PropertyDescriptor alternativePropertyDescriptor = (PropertyDescriptor)element$iv;
            boolean bl = false;
            if (alternativePropertyDescriptor == resultingDescriptor) continue;
            CallableMemberDescriptor callableMemberDescriptor2 = DescriptorUtils.unwrapSubstitutionOverride((CallableMemberDescriptor)alternativePropertyDescriptor);
            Intrinsics.checkNotNullExpressionValue(callableMemberDescriptor2, "unwrapSubstitutionOverride(...)");
            PropertyDescriptor basePropertyDescriptor = (PropertyDescriptor)callableMemberDescriptor2;
            DeclarationDescriptor declarationDescriptor2 = basePropertyDescriptor.getContainingDeclaration();
            ClassDescriptor propertyClassDescriptor = declarationDescriptor2 instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor2 : null;
            boolean hasLateInit = INSTANCE.selfOrBaseForFakeOverride(basePropertyDescriptor, JvmPropertyVsFieldAmbiguityCallChecker::check$lambda$0$0);
            boolean hasCustomGetter = INSTANCE.selfOrBaseForFakeOverride(basePropertyDescriptor, JvmPropertyVsFieldAmbiguityCallChecker::check$lambda$0$1);
            boolean hasCustomSetter = INSTANCE.selfOrBaseForFakeOverride(basePropertyDescriptor, JvmPropertyVsFieldAmbiguityCallChecker::check$lambda$0$2);
            String jvmDescriptorForField = MethodSignatureMappingKt.computeJvmDescriptorWithoutName(resultingDescriptor);
            String jvmDescriptorForProperty = MethodSignatureMappingKt.computeJvmDescriptorWithoutName(alternativePropertyDescriptor);
            if (!hasLateInit && !hasCustomGetter && !hasCustomSetter && basePropertyDescriptor.getModality() == Modality.FINAL && Intrinsics.areEqual(jvmDescriptorForField, jvmDescriptorForProperty) || fieldClassDescriptor != null && propertyClassDescriptor != null && DescriptorUtils.isSubclass(fieldClassDescriptor, propertyClassDescriptor) || !DescriptorVisibilities.isVisible(resolvedCall2.getDispatchReceiver(), alternativePropertyDescriptor, context2.getScope().getOwnerDescriptor(), false)) continue;
            DiagnosticFactory2<PsiElement, String, String> factory = hasCustomGetter ? ErrorsJvm.BASE_CLASS_FIELD_SHADOWS_DERIVED_CLASS_PROPERTY : (hasLateInit || hasCustomSetter ? ErrorsJvm.BACKING_FIELD_ACCESSED_DUE_TO_PROPERTY_FIELD_CONFLICT : (basePropertyDescriptor.getModality() != Modality.FINAL ? ErrorsJvm.BASE_CLASS_FIELD_MAY_SHADOW_DERIVED_CLASS_PROPERTY : ErrorsJvm.BASE_CLASS_FIELD_WITH_DIFFERENT_SIGNATURE_THAN_DERIVED_CLASS_PROPERTY));
            BindingTrace bindingTrace = context2.getTrace();
            Object object3 = fieldClassDescriptor;
            if (object3 == null || (object3 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object3)) == null || (object3 = ((FqName)object3).asString()) == null) {
                object3 = "unknown class";
            }
            if ((object2 = propertyClassDescriptor) == null || (object2 = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object2)) == null || (object2 = ((FqName)object2).asString()) == null) {
                object2 = "unknown class";
            }
            bindingTrace.report(factory.on(reportOn, (String)object3, (String)object2));
            return;
        }
    }

    private final boolean selfOrBaseForFakeOverride(PropertyDescriptor $this$selfOrBaseForFakeOverride, Function1<? super PropertyDescriptor, Boolean> predicate) {
        boolean bl;
        block5: {
            if (predicate.invoke($this$selfOrBaseForFakeOverride).booleanValue()) {
                return true;
            }
            if ($this$selfOrBaseForFakeOverride.getKind() != CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
                return false;
            }
            Collection<? extends PropertyDescriptor> collection = $this$selfOrBaseForFakeOverride.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PropertyDescriptor it = (PropertyDescriptor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull(it);
                    if (!INSTANCE.selfOrBaseForFakeOverride(it, predicate)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean check$lambda$0$0(PropertyDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.isLateInit();
    }

    private static final boolean check$lambda$0$1(PropertyDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        PropertyGetterDescriptor propertyGetterDescriptor = it.getGetter();
        return propertyGetterDescriptor != null ? !propertyGetterDescriptor.isDefault() : false;
    }

    private static final boolean check$lambda$0$2(PropertyDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        PropertySetterDescriptor propertySetterDescriptor = it.getSetter();
        return propertySetterDescriptor != null ? !propertySetterDescriptor.isDefault() : false;
    }
}

