/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.crypto.def;

import java.io.StringWriter;
import java.io.Writer;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.keycloak.common.crypto.PemUtilsProvider;
import org.keycloak.common.util.DerUtils;
import org.keycloak.common.util.PemException;

public class BCPemUtilsProvider
extends PemUtilsProvider {
    protected String encode(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter();
            JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)writer);
            pemWriter.writeObject(obj);
            pemWriter.flush();
            pemWriter.close();
            String s = writer.toString();
            return this.removeBeginEnd(s);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }

    public PublicKey decodePublicKey(String pem) {
        try {
            SubjectPublicKeyInfo publicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)this.pemToDer(pem));
            if (publicKeyInfo != null && publicKeyInfo.getAlgorithm() != null) {
                return new JcaPEMKeyConverter().getPublicKey(publicKeyInfo);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.decodePublicKey(pem, "RSA");
    }

    public PrivateKey decodePrivateKey(String pem) {
        if (pem == null) {
            return null;
        }
        try {
            byte[] der = this.pemToDer(pem);
            return DerUtils.decodePrivateKey((byte[])der);
        }
        catch (Exception e) {
            throw new PemException((Throwable)e);
        }
    }
}

