/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.boot.model.relational.Exportable;
import org.hibernate.boot.model.relational.Namespace;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.internal.AbstractSchemaPopulator;
import org.hibernate.tool.schema.internal.Helper;
import org.hibernate.tool.schema.internal.HibernateSchemaManagementTool;
import org.hibernate.tool.schema.internal.exec.JdbcContext;
import org.hibernate.tool.schema.spi.ContributableMatcher;
import org.hibernate.tool.schema.spi.ExecutionOptions;
import org.hibernate.tool.schema.spi.GenerationTarget;
import org.hibernate.tool.schema.spi.SchemaFilter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.SchemaTruncator;
import org.hibernate.tool.schema.spi.SqlScriptCommandExtractor;
import org.hibernate.tool.schema.spi.TargetDescriptor;
import org.jboss.logging.Logger;

public class SchemaTruncatorImpl
extends AbstractSchemaPopulator
implements SchemaTruncator {
    private static final Logger log = Logger.getLogger(SchemaTruncatorImpl.class);
    private final HibernateSchemaManagementTool tool;
    private final SchemaFilter schemaFilter;

    public SchemaTruncatorImpl(HibernateSchemaManagementTool tool, SchemaFilter truncatorFilter) {
        this.tool = tool;
        this.schemaFilter = truncatorFilter;
    }

    @Override
    public void doTruncate(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, TargetDescriptor targetDescriptor) {
        Map<String, Object> configurationValues = options.getConfigurationValues();
        JdbcContext jdbcContext = this.tool.resolveJdbcContext(configurationValues);
        GenerationTarget[] targets = this.tool.buildGenerationTargets(targetDescriptor, jdbcContext, configurationValues, true);
        this.doTruncate(metadata, options, contributableInclusionFilter, jdbcContext.getDialect(), targets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void doTruncate(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, Dialect dialect, GenerationTarget ... targets) {
        for (GenerationTarget target : targets) {
            target.prepare();
        }
        try {
            this.performTruncate(metadata, options, contributableInclusionFilter, dialect, targets);
        }
        finally {
            for (GenerationTarget target : targets) {
                try {
                    target.release();
                }
                catch (Exception e) {
                    log.debugf("Problem releasing GenerationTarget [%s] : %s", (Object)target, (Object)e.getMessage());
                }
            }
        }
    }

    private void performTruncate(Metadata metadata, ExecutionOptions options, ContributableMatcher contributableInclusionFilter, Dialect dialect, GenerationTarget ... targets) {
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        Formatter formatter = format ? FormatStyle.DDL.getFormatter() : FormatStyle.NONE.getFormatter();
        this.truncateFromMetadata(metadata, options, this.schemaFilter, contributableInclusionFilter, dialect, formatter, targets);
    }

    private void truncateFromMetadata(Metadata metadata, ExecutionOptions options, SchemaFilter schemaFilter, ContributableMatcher contributableInclusionFilter, Dialect dialect, Formatter formatter, GenerationTarget ... targets) {
        Database database = metadata.getDatabase();
        SqlStringGenerationContext context = Helper.createSqlStringGenerationContext(options, metadata);
        HashSet<String> exportIdentifiers = CollectionHelper.setOfSize(50);
        for (Namespace namespace : database.getNamespaces()) {
            if (!schemaFilter.includeNamespace(namespace)) continue;
            this.disableConstraints(namespace, metadata, formatter, options, schemaFilter, context, contributableInclusionFilter, targets);
            Helper.applySqlString(dialect.getTableCleaner().getSqlBeforeString(), formatter, options, targets);
            ArrayList<Table> list = new ArrayList<Table>(namespace.getTables().size());
            for (Table table : namespace.getTables()) {
                if (!table.isPhysicalTable() || !schemaFilter.includeTable(table) || !contributableInclusionFilter.matches(table)) continue;
                SchemaTruncatorImpl.checkExportIdentifier(table, exportIdentifiers);
                list.add(table);
            }
            Helper.applySqlStrings(dialect.getTableCleaner().getSqlTruncateStrings(list, metadata, context), formatter, options, targets);
            Helper.applySqlString(dialect.getTableCleaner().getSqlAfterString(), formatter, options, targets);
            this.enableConstraints(namespace, metadata, formatter, options, schemaFilter, context, contributableInclusionFilter, targets);
        }
        SqlScriptCommandExtractor commandExtractor = this.tool.getServiceRegistry().getService(SqlScriptCommandExtractor.class);
        boolean format = Helper.interpretFormattingEnabled(options.getConfigurationValues());
        this.applyImportSources(options, commandExtractor, format, dialect, targets);
    }

    private void disableConstraints(Namespace namespace, Metadata metadata, Formatter formatter, ExecutionOptions options, SchemaFilter schemaFilter, SqlStringGenerationContext context, ContributableMatcher contributableInclusionFilter, GenerationTarget ... targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !schemaFilter.includeTable(table) || !contributableInclusionFilter.matches(table)) continue;
            for (ForeignKey foreignKey : table.getForeignKeyCollection()) {
                if (dialect.canDisableConstraints()) {
                    Helper.applySqlString(dialect.getTableCleaner().getSqlDisableConstraintString(foreignKey, metadata, context), formatter, options, targets);
                    continue;
                }
                if (dialect.canBatchTruncate()) continue;
                Helper.applySqlStrings(dialect.getForeignKeyExporter().getSqlDropStrings(foreignKey, metadata, context), formatter, options, targets);
            }
        }
    }

    private void enableConstraints(Namespace namespace, Metadata metadata, Formatter formatter, ExecutionOptions options, SchemaFilter schemaFilter, SqlStringGenerationContext context, ContributableMatcher contributableInclusionFilter, GenerationTarget ... targets) {
        Dialect dialect = metadata.getDatabase().getJdbcEnvironment().getDialect();
        for (Table table : namespace.getTables()) {
            if (!table.isPhysicalTable() || !schemaFilter.includeTable(table) || !contributableInclusionFilter.matches(table)) continue;
            for (ForeignKey foreignKey : table.getForeignKeyCollection()) {
                if (dialect.canDisableConstraints()) {
                    Helper.applySqlString(dialect.getTableCleaner().getSqlEnableConstraintString(foreignKey, metadata, context), formatter, options, targets);
                    continue;
                }
                if (dialect.canBatchTruncate()) continue;
                Helper.applySqlStrings(dialect.getForeignKeyExporter().getSqlCreateStrings(foreignKey, metadata, context), formatter, options, targets);
            }
        }
    }

    private static void checkExportIdentifier(Exportable exportable, Set<String> exportIdentifiers) {
        String exportIdentifier = exportable.getExportIdentifier();
        if (exportIdentifiers.contains(exportIdentifier)) {
            throw new SchemaManagementException("SQL strings added more than once for: " + exportIdentifier);
        }
        exportIdentifiers.add(exportIdentifier);
    }

    @Override
    ClassLoaderService getClassLoaderService() {
        return this.tool.getServiceRegistry().getService(ClassLoaderService.class);
    }
}

