/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server;

import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.config.AbstractKafkaConfig;

public class DynamicThreadPool {
    public static final Set<String> RECONFIGURABLE_CONFIGS = Set.of("num.io.threads", "num.replica.fetchers", "num.recovery.threads.per.data.dir", "background.threads");

    private DynamicThreadPool() {
    }

    public static void validateReconfiguration(AbstractKafkaConfig currentConfig, AbstractKafkaConfig newConfig) {
        for (Map.Entry entry : newConfig.values().entrySet()) {
            int oldValue;
            int newValue;
            String key = (String)entry.getKey();
            if (!RECONFIGURABLE_CONFIGS.contains(key) || (newValue = ((Integer)entry.getValue()).intValue()) == (oldValue = DynamicThreadPool.getValue(currentConfig, key))) continue;
            String errorMsg = String.format("Dynamic thread count update validation failed for %s=%d", key, newValue);
            if (newValue <= 0) {
                throw new ConfigException(String.format("%s, value should be at least 1", errorMsg));
            }
            if (newValue < oldValue / 2) {
                throw new ConfigException(String.format("%s, value should be at least half the current value %d", errorMsg, oldValue));
            }
            if (newValue <= oldValue * 2) continue;
            throw new ConfigException(String.format("%s, value should not be greater than double the current value %d", errorMsg, oldValue));
        }
    }

    public static int getValue(AbstractKafkaConfig config, String name) {
        return switch (name) {
            case "num.io.threads" -> config.numIoThreads();
            case "num.replica.fetchers" -> config.numReplicaFetchers();
            case "num.recovery.threads.per.data.dir" -> config.numRecoveryThreadsPerDataDir();
            case "background.threads" -> config.backgroundThreads();
            default -> throw new IllegalStateException(String.format("Unexpected config %s", name));
        };
    }
}

