/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;

public class JSLscpScriptDlg
extends JDialog {
    private final JTextPane textPane = new JTextPane();
    private final JButton btnSaveAs = new JButton(StdI18n.i18n.getButtonLabel("JSLscpScriptDlg.btnSaveAs"));
    private final JButton btnClose = new JButton(StdI18n.i18n.getButtonLabel("close"));

    public JSLscpScriptDlg() {
        this(CC.getMainFrame());
    }

    public JSLscpScriptDlg(Frame frame) {
        super(frame);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        JScrollPane jScrollPane = new JScrollPane(this.textPane);
        jScrollPane.setAlignmentX(1.0f);
        jPanel.add(jScrollPane);
        jPanel.add(Box.createRigidArea(new Dimension(0, 17)));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(this.btnSaveAs);
        jPanel2.add(Box.createRigidArea(new Dimension(6, 0)));
        jPanel2.add(this.btnClose);
        jPanel2.setAlignmentX(1.0f);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.pack();
        this.setSize(500, 400);
        this.setLocationRelativeTo(this.getOwner());
        this.btnSaveAs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSLscpScriptDlg.this.saveScript();
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSLscpScriptDlg.this.setVisible(false);
            }
        });
    }

    private JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public void setCommands(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : stringArray) {
            stringBuffer.append(string).append("\n");
        }
        this.textPane.setText(stringBuffer.toString());
    }

    private void saveScript() {
        Object object;
        File file = StdUtils.showSaveLscpFileChooser(this);
        if (file == null) {
            return;
        }
        boolean bl = this.preferences().getBoolProperty("nativeFileChoosers");
        if (!(!file.exists() || CC.isMacOS() && bl)) {
            object = StdI18n.i18n.getMessage("JSLscpScriptDlg.overwriteFile?");
            if (!HF.showYesNoDialog(CC.getMainFrame(), (String)object)) {
                return;
            }
        }
        try {
            object = new FileOutputStream(file);
            ((FileOutputStream)object).write(this.textPane.getText().getBytes("US-ASCII"));
            ((FileOutputStream)object).close();
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.FINE, HF.getErrorMessage(exception), exception);
            HF.showErrorMessage(exception);
        }
    }
}

