/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import org.jsampler.CC;
import org.jsampler.MidiInstrumentMap;
import org.jsampler.view.MidiMapTableModel;

public class MidiMapTable
extends JTable {
    public MidiMapTable() {
        this.setModel(new MidiMapTableModel(this));
        this.setSelectionMode(0);
        this.setFillsViewportHeight(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getButton() != 1) {
                    return;
                }
                int n = MidiMapTable.this.rowAtPoint(mouseEvent.getPoint());
                if (n == -1) {
                    MidiMapTable.this.clearSelection();
                    return;
                }
            }
        });
    }

    public MidiInstrumentMap getSelectedMidiInstrumentMap() {
        int n = this.getSelectedRow();
        if (n == -1) {
            return null;
        }
        return CC.getSamplerModel().getMidiInstrumentMap(n);
    }

    public void setSelectedMidiInstrumentMap(MidiInstrumentMap midiInstrumentMap) {
        int n = CC.getSamplerModel().getMidiInstrumentMapIndex(midiInstrumentMap);
        if (n < 0) {
            this.clearSelection();
            return;
        }
        this.setRowSelectionInterval(n, n);
    }
}

