/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILazyParseableElementTypeBase;
import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.ImmutableCharSequence;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class LazyParseableElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance(LazyParseableElement.class);
    private static final Supplier<CharSequence> NO_TEXT = () -> null;
    private final ReentrantLock myLock;
    @NotNull
    private volatile Supplier<CharSequence> myText;
    private volatile boolean myParsed;
    private static boolean ourParsingAllowed = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyParseableElement(@NotNull IElementType type, @Nullable CharSequence text) {
        if (type == null) {
            LazyParseableElement.$$$reportNull$$$0(0);
        }
        super(type);
        this.myLock = new ReentrantLock();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (text == null) {
                this.myParsed = true;
                this.myText = NO_TEXT;
            } else {
                CharSequence sequence2 = ImmutableCharSequence.asImmutable(text);
                this.myText = () -> sequence2;
                this.setCachedLength(text.length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                this.myText = NO_TEXT;
            } else {
                this.setCachedLength(this.myText.get().length());
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    @Override
    @NotNull
    public String getText() {
        CharSequence text = this.myText();
        if (text != null) {
            String string = text.toString();
            if (string == null) {
                LazyParseableElement.$$$reportNull$$$0(1);
            }
            return string;
        }
        String s2 = super.getText();
        this.myText = new SoftReference<String>(s2);
        String string = s2;
        if (string == null) {
            LazyParseableElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public CharSequence getChars() {
        CharSequence text = this.myText();
        if (text == null) {
            text = super.getText();
            this.myText = new SoftReference<CharSequence>(text);
        }
        CharSequence charSequence = text;
        if (charSequence == null) {
            LazyParseableElement.$$$reportNull$$$0(3);
        }
        return charSequence;
    }

    @Override
    public int getTextLength() {
        CharSequence text = this.myText();
        if (text != null) {
            return text.length();
        }
        return super.getTextLength();
    }

    @Override
    public int hc() {
        CharSequence text = this.myText();
        return text == null ? super.hc() : LeafElement.leafHC(text);
    }

    @Override
    public boolean textContains(char c2) {
        CharSequence text = this.myText();
        if (text != null) {
            return StringUtil.indexOf(text, c2) != -1;
        }
        return super.textContains(c2);
    }

    @Override
    protected int textMatches(@NotNull CharSequence buffer, int start) {
        CharSequence text;
        if (buffer == null) {
            LazyParseableElement.$$$reportNull$$$0(4);
        }
        if ((text = this.myText()) != null) {
            return LeafElement.leafTextMatches(text, buffer, start);
        }
        return super.textMatches(buffer, start);
    }

    public boolean isParsed() {
        return this.myParsed;
    }

    private CharSequence myText() {
        return this.myText.get();
    }

    @Override
    final void setFirstChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setFirstChildNode(child);
    }

    @Override
    final void setLastChildNode(TreeElement child) {
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon");
        }
        super.setLastChildNode(child);
    }

    private void ensureParsed() {
        if (!ourParsingAllowed) {
            LOG.error("Parsing not allowed!!!");
        }
        if (this.myParsed) {
            return;
        }
        LazyParseableElement.waitForLock(this.myLock);
        try {
            if (this.myParsed) {
                return;
            }
            CharSequence text = this.myText.get();
            assert (text != null);
            FileElement fileElement = TreeUtil.getFileElement(this);
            if (fileElement == null) {
                LOG.error("Chameleons must not be parsed till they're in file tree: " + this);
            } else {
                fileElement.assertReadAccessAllowed();
            }
            if (this.rawFirstChild() != null) {
                LOG.error("Reentrant parsing?");
            }
            DebugUtil.performPsiModification("lazy-parsing", () -> {
                TreeElement parsedNode = (TreeElement)((ILazyParseableElementTypeBase)((Object)this.getElementType())).parseContents(this);
                this.assertTextLengthIntact(text, parsedNode);
                if (parsedNode != null) {
                    this.setChildren(parsedNode);
                }
                this.myParsed = true;
                this.myText = new SoftReference<CharSequence>(text);
            });
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void assertTextLengthIntact(CharSequence text, TreeElement child) {
        int length = 0;
        while (child != null) {
            length += child.getTextLength();
            child = child.getTreeNext();
        }
        if (length != text.length()) {
            LOG.error("Text mismatch in " + ObjectUtils.objectInfo(this.getElementType()), (Throwable)PluginException.createByClass("Text mismatch", null, this.getElementType().getClass()), new Attachment("code.txt", text.toString()));
        }
    }

    private void setChildren(@NotNull TreeElement parsedNode) {
        if (parsedNode == null) {
            LazyParseableElement.$$$reportNull$$$0(5);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            try {
                TreeElement last = LazyParseableElement.rawSetParents(parsedNode, this);
                super.setFirstChildNode(parsedNode);
                super.setLastChildNode(last);
            }
            catch (Throwable e2) {
                LOG.error("Chameleon expansion may not be interrupted by exceptions", e2);
            }
        });
    }

    @Override
    public void rawAddChildrenWithoutNotifications(@NotNull TreeElement first) {
        if (first == null) {
            LazyParseableElement.$$$reportNull$$$0(6);
        }
        if (!this.isParsed()) {
            LOG.error("Mutating collapsed chameleon " + this.getClass());
        }
        super.rawAddChildrenWithoutNotifications(first);
    }

    @Override
    public TreeElement getFirstChildNode() {
        this.ensureParsed();
        return super.getFirstChildNode();
    }

    @Override
    public TreeElement getLastChildNode() {
        this.ensureParsed();
        return super.getLastChildNode();
    }

    public int copyTo(char @Nullable [] buffer, int start) {
        CharSequence text = this.myText();
        if (text == null) {
            return -1;
        }
        if (buffer != null) {
            CharArrayUtil.getChars(text, buffer, start);
        }
        return start + text.length();
    }

    @TestOnly
    public static void setParsingAllowed(boolean allowed) {
        ourParsingAllowed = allowed;
    }

    private static void waitForLock(@NotNull ReentrantLock ml) {
        if (ml == null) {
            LazyParseableElement.$$$reportNull$$$0(7);
        }
        while (true) {
            try {
                if (ml.tryLock(10L, TimeUnit.MILLISECONDS)) {
                    return;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parsedNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ml";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/LazyParseableElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChars";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setChildren";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "rawAddChildrenWithoutNotifications";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "waitForLock";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

