/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorNonRootImpl;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import org.jetbrains.annotations.NotNull;

public abstract class PackageFragmentDescriptorImpl
extends DeclarationDescriptorNonRootImpl
implements PackageFragmentDescriptor {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final String debugString;

    public PackageFragmentDescriptorImpl(@NotNull ModuleDescriptor module, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        super(module, Annotations.Companion.getEMPTY(), fqName2.shortNameOrSpecial(), SourceElement.NO_SOURCE);
        this.fqName = fqName2;
        this.debugString = "package " + this.fqName + " of " + module;
    }

    @Override
    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @Override
    public <R, D> R accept(@NotNull DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, (String)"visitor");
        return visitor2.visitPackageFragmentDescriptor(this, data2);
    }

    @Override
    @NotNull
    public ModuleDescriptor getContainingDeclaration() {
        return (ModuleDescriptor)super.getContainingDeclaration();
    }

    @Override
    @NotNull
    public SourceElement getSource() {
        SourceElement sourceElement = SourceElement.NO_SOURCE;
        Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
        return sourceElement;
    }

    @Override
    @NotNull
    public String toString() {
        return this.debugString;
    }
}

