/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.options;

import com.intellij.openapi.util.registry.Registry;
import java.awt.Dimension;
import java.awt.Rectangle;
import org.jetbrains.annotations.NonNls;

public interface ZoomOptions
extends Cloneable {
    @NonNls
    public static final String ATTR_PREFIX = "Editor.Zoom.";
    @NonNls
    public static final String ATTR_PREFFERED_WIDTH = "Editor.Zoom.prefferedWidth";
    @NonNls
    public static final String ATTR_PREFFERED_HEIGHT = "Editor.Zoom.prefferedHeight";
    public static final Dimension DEFAULT_PREFFERED_SIZE = new Dimension(128, 128);

    default public boolean isWheelZooming() {
        return Registry.is((String)"ide.images.wheel.zooming", (boolean)true);
    }

    default public boolean isSmartZooming() {
        return this.isWheelZooming();
    }

    default public Double getSmartZoomFactor(Rectangle imageSize, Dimension viewPort, int inset) {
        if (imageSize == null) {
            return null;
        }
        if (imageSize.getWidth() == 0.0 || imageSize.getHeight() == 0.0) {
            return null;
        }
        int width = imageSize.width;
        int height = imageSize.height;
        Dimension preferredMinimumSize = this.getPrefferedSize();
        if (width < preferredMinimumSize.width && height < preferredMinimumSize.height) {
            double factor = (preferredMinimumSize.getWidth() / (double)width + preferredMinimumSize.getHeight() / (double)height) / 2.0;
            return Math.ceil(factor);
        }
        viewPort.height -= inset * 2;
        viewPort.width -= inset * 2;
        if (viewPort.width <= 0 || viewPort.height <= 0) {
            return null;
        }
        if (viewPort.width < width || viewPort.height < height) {
            return Math.min((double)viewPort.height / (double)height, (double)viewPort.width / (double)width);
        }
        return 1.0;
    }

    public Dimension getPrefferedSize();

    public void inject(ZoomOptions var1);

    public boolean setOption(String var1, Object var2);
}

