/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.synthetic.diagnostic;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.android.synthetic.descriptors.AndroidSyntheticPackageFragmentDescriptor;
import org.jetbrains.kotlin.android.synthetic.diagnostic.ErrorsAndroid;
import org.jetbrains.kotlin.android.synthetic.res.AndroidSyntheticProperty;
import org.jetbrains.kotlin.android.synthetic.res.SyntheticDescriptorGenerationKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001c\u0010\f\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u0005*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u0015\u001a\u00020\u0005*\u00020\r2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/android/synthetic/diagnostic/AndroidExtensionPropertiesCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkDeprecated", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "packageDescriptor", "Lorg/jetbrains/kotlin/android/synthetic/descriptors/AndroidSyntheticPackageFragmentDescriptor;", "checkUnresolvedWidgetType", "property", "Lorg/jetbrains/kotlin/android/synthetic/res/AndroidSyntheticProperty;", "checkPartiallyDefinedResource", "findLeftOutermostQualifiedExpression", "Lorg/jetbrains/kotlin/psi/KtElement;", "calleeExpression", "android-extensions-compiler"})
public final class AndroidExtensionPropertiesCallChecker
implements CallChecker {
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall, (String)"resolvedCall");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if ((reportOn instanceof KtExpression ? (KtExpression)reportOn : null) == null) {
            return;
        }
        CallableDescriptor callableDescriptor = resolvedCall.getResultingDescriptor();
        PropertyDescriptor propertyDescriptor = callableDescriptor instanceof PropertyDescriptor ? (PropertyDescriptor)callableDescriptor : null;
        if (propertyDescriptor == null) {
            return;
        }
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        DeclarationDescriptor declarationDescriptor = propertyDescriptor2.getContainingDeclaration();
        AndroidSyntheticPackageFragmentDescriptor androidSyntheticPackageFragmentDescriptor = declarationDescriptor instanceof AndroidSyntheticPackageFragmentDescriptor ? (AndroidSyntheticPackageFragmentDescriptor)declarationDescriptor : null;
        if (androidSyntheticPackageFragmentDescriptor == null) {
            return;
        }
        AndroidSyntheticPackageFragmentDescriptor containingPackage = androidSyntheticPackageFragmentDescriptor;
        AndroidSyntheticProperty androidSyntheticProperty = propertyDescriptor2 instanceof AndroidSyntheticProperty ? (AndroidSyntheticProperty)propertyDescriptor2 : null;
        if (androidSyntheticProperty == null) {
            return;
        }
        AndroidSyntheticProperty androidSyntheticProperty2 = androidSyntheticProperty;
        BindingTrace $this$check_u24lambda_u240 = context.getTrace();
        boolean bl = false;
        this.checkUnresolvedWidgetType((DiagnosticSink)$this$check_u24lambda_u240, (KtExpression)reportOn, androidSyntheticProperty2);
        this.checkDeprecated((DiagnosticSink)$this$check_u24lambda_u240, (KtExpression)reportOn, containingPackage);
        this.checkPartiallyDefinedResource((DiagnosticSink)$this$check_u24lambda_u240, resolvedCall, androidSyntheticProperty2, context);
    }

    private final void checkDeprecated(DiagnosticSink $this$checkDeprecated, KtExpression expression, AndroidSyntheticPackageFragmentDescriptor packageDescriptor) {
        if (packageDescriptor.getPackageData().isDeprecated()) {
            $this$checkDeprecated.report((Diagnostic)ErrorsAndroid.SYNTHETIC_DEPRECATED_PACKAGE.on((PsiElement)expression));
        }
    }

    private final void checkUnresolvedWidgetType(DiagnosticSink $this$checkUnresolvedWidgetType, KtExpression expression, AndroidSyntheticProperty property2) {
        if (!SyntheticDescriptorGenerationKt.isErrorType(property2)) {
            return;
        }
        String string = property2.getErrorType();
        if (string == null) {
            return;
        }
        String type = string;
        DiagnosticFactory1<KtExpression, String> warning = StringsKt.contains$default((CharSequence)type, (char)'.', (boolean)false, (int)2, null) ? ErrorsAndroid.SYNTHETIC_UNRESOLVED_WIDGET_TYPE : ErrorsAndroid.SYNTHETIC_INVALID_WIDGET_TYPE;
        $this$checkUnresolvedWidgetType.report((Diagnostic)warning.on((PsiElement)expression, (Object)type));
    }

    private final void checkPartiallyDefinedResource(DiagnosticSink $this$checkPartiallyDefinedResource, ResolvedCall<?> resolvedCall, AndroidSyntheticProperty property2, CallCheckerContext context) {
        if (!property2.getResource().getPartiallyDefined()) {
            return;
        }
        KtExpression ktExpression = resolvedCall.getCall().getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression calleeExpression = ktExpression;
        KotlinType kotlinType = context.getResolutionContext().expectedType;
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"expectedType");
        KotlinType expectedType = kotlinType;
        if (!(TypeUtils.noExpectedType((KotlinType)expectedType) || expectedType.isMarkedNullable() || FlexibleTypesKt.isFlexible((KotlinType)expectedType))) {
            $this$checkPartiallyDefinedResource.report((Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((PsiElement)calleeExpression));
            return;
        }
        KtElement ktElement = this.findLeftOutermostQualifiedExpression(calleeExpression);
        if (ktElement == null) {
            return;
        }
        KtElement outermostQualifiedExpression = ktElement;
        PsiElement usage = outermostQualifiedExpression.getParent();
        if (usage instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)usage).getReceiverExpression(), (Object)outermostQualifiedExpression)) {
            $this$checkPartiallyDefinedResource.report((Diagnostic)ErrorsAndroid.UNSAFE_CALL_ON_PARTIALLY_DEFINED_RESOURCE.on((PsiElement)calleeExpression));
        }
    }

    private final KtElement findLeftOutermostQualifiedExpression(KtExpression calleeExpression) {
        KtExpression ktExpression = calleeExpression;
        if (ktExpression == null || (ktExpression = ktExpression.getParent()) == null) {
            return null;
        }
        KtExpression parent = ktExpression;
        if (parent instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent).getSelectorExpression(), (Object)calleeExpression)) {
            return this.findLeftOutermostQualifiedExpression(parent);
        }
        return (KtElement)calleeExpression;
    }
}

