/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemProjectLinkListener;
import com.intellij.openapi.externalSystem.autolink.ExternalSystemUnlinkedProjectAware;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenOpenProjectProvider;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0016J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u001e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\u001e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\nH\u0096@\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware;", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemUnlinkedProjectAware;", "<init>", "()V", "systemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "getSystemId", "()Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "buildFileExtensions", "", "", "()[Ljava/lang/String;", "isBuildFile", "", "project", "Lcom/intellij/openapi/project/Project;", "buildFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLinkedProject", "externalProjectPath", "subscribe", "", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "linkAndLoadProjectAsync", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "unlinkProject", "ProjectsTreeListener", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenUnlinkedProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenUnlinkedProjectAware.kt\norg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1761#2,3:64\n*S KotlinDebug\n*F\n+ 1 MavenUnlinkedProjectAware.kt\norg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware\n*L\n26#1:64,3\n*E\n"})
public final class MavenUnlinkedProjectAware
implements ExternalSystemUnlinkedProjectAware {
    @NotNull
    private final ProjectSystemId systemId = MavenUtil.SYSTEM_ID;

    @NotNull
    public ProjectSystemId getSystemId() {
        return this.systemId;
    }

    @NotNull
    public String[] buildFileExtensions() {
        String[] stringArray = new String[]{"xml"};
        return stringArray;
    }

    public boolean isBuildFile(@NotNull Project project, @NotNull VirtualFile buildFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)buildFile, (String)"buildFile");
        return MavenUtil.isPomFile(project, buildFile);
    }

    public boolean isLinkedProject(@NotNull Project project, @NotNull String externalProjectPath) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)externalProjectPath, (String)"externalProjectPath");
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
            List<MavenProject> list = mavenProjectsManager.getProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl2 = false;
                    if (!VfsUtilCore.pathEqualsTo((VirtualFile)it.getDirectoryFile(), (String)externalProjectPath)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public void subscribe(@NotNull Project project, @NotNull ExternalSystemProjectLinkListener listener2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
        mavenProjectsManager.addProjectsTreeListener(new ProjectsTreeListener(project, listener2), parentDisposable);
    }

    @Nullable
    public Object linkAndLoadProjectAsync(@NotNull Project project, @NotNull String externalProjectPath, @NotNull Continuation<? super Unit> $completion) {
        Object object = new MavenOpenProjectProvider().linkToExistingProjectAsync(externalProjectPath, project, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object unlinkProject(@NotNull Project project, @NotNull String externalProjectPath, @NotNull Continuation<? super Unit> $completion) {
        Object object = new MavenOpenProjectProvider().unlinkProject(project, externalProjectPath, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J0\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c0\u001b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001bH\u0016J4\u0010 \u001a.\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0013\u00a2\u0006\u0002\b\u00120\u000f\u00a2\u0006\u0002\b\u0012H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rRF\u0010\u000e\u001a.\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u0010 \u0011*\u0015\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00100\u00100\u0013\u00a2\u0006\u0002\b\u00120\u000f\u00a2\u0006\u0002\b\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006!"}, d2={"Lorg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware$ProjectsTreeListener;", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree$Listener;", "project", "Lcom/intellij/openapi/project/Project;", "listener", "Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;)V", "getListener", "()Lcom/intellij/openapi/externalSystem/autolink/ExternalSystemProjectLinkListener;", "mavenProjectsManager", "Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "getMavenProjectsManager", "()Lorg/jetbrains/idea/maven/project/MavenProjectsManager;", "mavenProjects", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getMavenProjects", "()Ljava/util/Set;", "setMavenProjects", "(Ljava/util/Set;)V", "projectsUpdated", "", "updated", "", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "deleted", "getMavenProjectPaths", "intellij.maven"})
    @SourceDebugExtension(value={"SMAP\nMavenUnlinkedProjectAware.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenUnlinkedProjectAware.kt\norg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware$ProjectsTreeListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1321#2,2:64\n1869#3,2:66\n*S KotlinDebug\n*F\n+ 1 MavenUnlinkedProjectAware.kt\norg/jetbrains/idea/maven/project/MavenUnlinkedProjectAware$ProjectsTreeListener\n*L\n52#1:64,2\n53#1:66,2\n*E\n"})
    private static final class ProjectsTreeListener
    implements MavenProjectsTree.Listener {
        @NotNull
        private final ExternalSystemProjectLinkListener listener;
        @NotNull
        private final MavenProjectsManager mavenProjectsManager;
        @NotNull
        private Set<String> mavenProjects;

        public ProjectsTreeListener(@NotNull Project project, @NotNull ExternalSystemProjectLinkListener listener2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
            this.listener = listener2;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"getInstance(...)");
            this.mavenProjectsManager = mavenProjectsManager;
            this.mavenProjects = this.getMavenProjectPaths();
        }

        @NotNull
        public final ExternalSystemProjectLinkListener getListener() {
            return this.listener;
        }

        @NotNull
        public final MavenProjectsManager getMavenProjectsManager() {
            return this.mavenProjectsManager;
        }

        @NotNull
        public final Set<String> getMavenProjects() {
            return this.mavenProjects;
        }

        public final void setMavenProjects(@NotNull Set<String> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.mavenProjects = set;
        }

        @Override
        public void projectsUpdated(@NotNull List<? extends Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            MavenProject it;
            Object element$iv;
            Intrinsics.checkNotNullParameter(updated, (String)"updated");
            Intrinsics.checkNotNullParameter(deleted, (String)"deleted");
            Object $this$forEach$iv = SequencesKt.filterNot((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)updated), ProjectsTreeListener::projectsUpdated$lambda$0), arg_0 -> ProjectsTreeListener.projectsUpdated$lambda$1(this, arg_0));
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (MavenProject)element$iv;
                boolean bl = false;
                this.listener.onProjectLinked(it.getDirectory());
            }
            $this$forEach$iv = deleted;
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                element$iv = iterator.next();
                it = (MavenProject)element$iv;
                boolean bl = false;
                this.listener.onProjectUnlinked(it.getDirectory());
            }
            this.mavenProjects = this.getMavenProjectPaths();
        }

        private final Set<String> getMavenProjectPaths() {
            List<MavenProject> list = this.mavenProjectsManager.getProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getProjects(...)");
            Sequence sequence = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)list), ProjectsTreeListener::getMavenProjectPaths$lambda$4);
            Set set = CollectionFactory.createFilePathSet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createFilePathSet(...)");
            Collection collection = SequencesKt.toCollection((Sequence)sequence, (Collection)set);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"toCollection(...)");
            return (Set)collection;
        }

        private static final MavenProject projectsUpdated$lambda$0(Pair it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return (MavenProject)it.first;
        }

        private static final boolean projectsUpdated$lambda$1(ProjectsTreeListener this$0, MavenProject it) {
            return this$0.mavenProjects.contains(it.getDirectory());
        }

        private static final String getMavenProjectPaths$lambda$4(MavenProject it) {
            return it.getDirectory();
        }
    }
}

