/*
 * Decompiled with CFR 0.152.
 */
package git4idea.index;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.DiffRequestFactory;
import com.intellij.diff.DiffVcsDataKeys;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.impl.DiffEditorTitleDetails;
import com.intellij.diff.impl.DiffEditorTitleDetailsKt;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.i18n.GitBundle;
import git4idea.index.ContentVersion;
import git4idea.index.GitFileStatus;
import git4idea.index.GitFileStatusKt;
import git4idea.index.GitFileStatusNodeProducerBase;
import git4idea.index.GitIndexUtil;
import git4idea.index.HeadContentRevision;
import git4idea.index.HeadInfo;
import git4idea.index.KindTag;
import git4idea.index.MergedProducer;
import git4idea.index.StagedContentRevision;
import git4idea.index.StagedDiffRequest;
import git4idea.index.StagedProducer;
import git4idea.index.ThreeSidesProducer;
import git4idea.index.UnStagedProducer;
import git4idea.index.ui.GitFileStatusNode;
import git4idea.index.ui.NodeKind;
import git4idea.index.vfs.GitIndexFileSystemRefresher;
import git4idea.index.vfs.GitIndexVirtualFile;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.util.GitFileUtils;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000z\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a \u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a0\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010\u001a*\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u001a\u001a\u00020\u0007*\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0017\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a\u0017\u0010 \u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002\u001a7\u0010!\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u000b\u0010#\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u0002\u001a \u0010$\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a(\u0010&\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u001cH\u0002\u001a \u0010(\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a(\u0010)\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u001a\u001e\u0010+\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a&\u0010,\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010-\u001a\u00020\u0007*\u00020\u00052\u0006\u0010.\u001a\u00020\u0010H\u0002\u001a\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0003\u001a\u0010\u0010/\u001a\u00020\u001c2\u0006\u0010\r\u001a\u00020\u000eH\u0003\"\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"createTwoSidesDiffRequestProducer", "Lcom/intellij/openapi/vcs/changes/ui/ChangeDiffRequestChain$Producer;", "project", "Lcom/intellij/openapi/project/Project;", "statusNode", "Lgit4idea/index/ui/GitFileStatusNode;", "forDiffPreview", "", "createThreeSidesDiffRequestProducer", "createChange", "Lcom/intellij/openapi/vcs/changes/Change;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lgit4idea/index/GitFileStatus;", "beforeVersion", "Lgit4idea/index/ContentVersion;", "afterVersion", "createContentRevision", "Lcom/intellij/openapi/vcs/changes/ContentRevision;", "version", "HEAD_INFO", "Lcom/intellij/openapi/util/Key;", "Lgit4idea/index/HeadInfo;", "getHEAD_INFO", "()Lcom/intellij/openapi/util/Key;", "isCurrent", "getCurrentRevision", "", "Lcom/intellij/openapi/util/NlsSafe;", "repository", "Lgit4idea/repo/GitRepository;", "getPresentableRevision", "headDiffContent", "Lcom/intellij/diff/contents/DiffContent;", "currentRevision", "stagedDiffContent", "localDiffContent", "headContentBytes", "", "stagedContentFile", "compareHeadWithStaged", "Lcom/intellij/diff/requests/DiffRequest;", "compareStagedWithLocal", "compareThreeVersions", "has", "contentVersion", "getTitle", "kind", "Lgit4idea/index/ui/NodeKind;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStageDiffUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStageDiffUtil.kt\ngit4idea/index/GitStageDiffUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,459:1\n1#2:460\n*E\n"})
public final class GitStageDiffUtilKt {
    @NotNull
    private static final Key<HeadInfo> HEAD_INFO;

    @Nullable
    public static final ChangeDiffRequestChain.Producer createTwoSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode, boolean forDiffPreview) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        return switch (WhenMappings.$EnumSwitchMapping$0[statusNode.getKind().ordinal()]) {
            case 1 -> new StagedProducer(project, statusNode, forDiffPreview);
            case 2 -> new UnStagedProducer(project, statusNode);
            case 3 -> new MergedProducer(project, statusNode);
            case 4 -> (ChangeDiffRequestChain.Producer)UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath(), (ChangesBrowserNode.Tag)((ChangesBrowserNode.Tag)KindTag.Companion.getTag$intellij_vcs_git(NodeKind.UNSTAGED)));
            case 5 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public static /* synthetic */ ChangeDiffRequestChain.Producer createTwoSidesDiffRequestProducer$default(Project project, GitFileStatusNode gitFileStatusNode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return GitStageDiffUtilKt.createTwoSidesDiffRequestProducer(project, gitFileStatusNode, bl);
    }

    @Nullable
    public static final ChangeDiffRequestChain.Producer createThreeSidesDiffRequestProducer(@NotNull Project project, @NotNull GitFileStatusNode statusNode, boolean forDiffPreview) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)statusNode, (String)"statusNode");
        boolean hasThreeSides = GitStageDiffUtilKt.has(statusNode, ContentVersion.HEAD) && GitStageDiffUtilKt.has(statusNode, ContentVersion.STAGED) && GitStageDiffUtilKt.has(statusNode, ContentVersion.LOCAL);
        return switch (WhenMappings.$EnumSwitchMapping$0[statusNode.getKind().ordinal()]) {
            case 1 -> hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode, forDiffPreview) : (GitFileStatusNodeProducerBase)new StagedProducer(project, statusNode, forDiffPreview);
            case 2 -> hasThreeSides ? (GitFileStatusNodeProducerBase)new ThreeSidesProducer(project, statusNode, forDiffPreview) : (GitFileStatusNodeProducerBase)new UnStagedProducer(project, statusNode);
            case 3 -> new MergedProducer(project, statusNode);
            case 4 -> (ChangeDiffRequestChain.Producer)UnversionedDiffRequestProducer.create((Project)project, (FilePath)statusNode.getFilePath(), (ChangesBrowserNode.Tag)((ChangesBrowserNode.Tag)KindTag.Companion.getTag$intellij_vcs_git(NodeKind.UNSTAGED)));
            case 5 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Nullable
    public static final Change createChange(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status, @NotNull ContentVersion beforeVersion, @NotNull ContentVersion afterVersion) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        Intrinsics.checkNotNullParameter((Object)((Object)beforeVersion), (String)"beforeVersion");
        Intrinsics.checkNotNullParameter((Object)((Object)afterVersion), (String)"afterVersion");
        ContentRevision bRev = GitStageDiffUtilKt.createContentRevision(project, root, status, beforeVersion);
        ContentRevision aRev = GitStageDiffUtilKt.createContentRevision(project, root, status, afterVersion);
        return bRev != null || aRev != null ? new Change(bRev, aRev) : null;
    }

    private static final ContentRevision createContentRevision(Project project, VirtualFile root, GitFileStatus status, ContentVersion version) {
        if (!GitFileStatusKt.has(status, version)) {
            return null;
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[version.ordinal()]) {
            case 1 -> (ContentRevision)new HeadContentRevision(project, root, status);
            case 2 -> (ContentRevision)new StagedContentRevision(project, root, status);
            case 3 -> (ContentRevision)new CurrentContentRevision(GitFileStatusKt.path(status, version));
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final Key<HeadInfo> getHEAD_INFO() {
        return HEAD_INFO;
    }

    public static final boolean isCurrent(@NotNull HeadInfo $this$isCurrent, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$isCurrent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitRepository gitRepository = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick($this$isCurrent.getRoot());
        if (gitRepository == null) {
            return false;
        }
        GitRepository repository2 = gitRepository;
        return Intrinsics.areEqual((Object)repository2.getCurrentRevision(), (Object)$this$isCurrent.getRevision());
    }

    private static final String getCurrentRevision(GitRepository repository2) {
        Object object = repository2;
        if (object == null || (object = object.getCurrentRevision()) == null) {
            object = "HEAD";
        }
        return object;
    }

    private static final String getPresentableRevision(GitRepository repository2) {
        Object object;
        block3: {
            block2: {
                object = repository2;
                if (object == null || (object = object.getCurrentRevision()) == null) break block2;
                Object p0 = object;
                boolean bl = false;
                String string = DvcsUtil.getShortHash((String)p0);
                object = string;
                if (string != null) break block3;
            }
            object = "HEAD";
        }
        return object;
    }

    private static final DiffContent headDiffContent(Project project, VirtualFile root, GitFileStatus status, String currentRevision, boolean forDiffPreview) throws VcsException, IOException {
        DiffContent diffContent;
        if (!GitFileStatusKt.has(status, ContentVersion.HEAD)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
            return (DiffContent)emptyContent;
        }
        GitRevisionNumber currentRevisionNumber = new GitRevisionNumber(currentRevision);
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, status.getPath());
        if (submodule != null) {
            Hash hash = GitIndexUtil.loadSubmoduleHashAt(submodule.getRepository(), submodule.getParent(), (VcsRevisionNumber)currentRevisionNumber);
            if (hash == null) {
                throw new VcsException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            Hash hash2 = hash;
            diffContent = (DiffContent)DiffContentFactory.getInstance().create(project, hash2.asString());
        } else {
            byte[] headContent = GitStageDiffUtilKt.headContentBytes(project, root, status, currentRevision);
            diffContent = DiffContentFactoryEx.getInstanceEx().createFromBytes(project, headContent, status.getPath());
        }
        DiffContent diffContent2 = diffContent;
        Intrinsics.checkNotNull((Object)diffContent2);
        DiffContent diffContent3 = diffContent2;
        diffContent3.putUserData(DiffVcsDataKeys.REVISION_INFO, (Object)new Pair((Object)status.getPath(), (Object)currentRevisionNumber));
        if (forDiffPreview) {
            diffContent3.putUserData(HEAD_INFO, (Object)new HeadInfo(root, currentRevision));
        }
        return diffContent3;
    }

    static /* synthetic */ DiffContent headDiffContent$default(Project project, VirtualFile virtualFile, GitFileStatus gitFileStatus, String string, boolean bl, int n, Object object) throws VcsException, IOException {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return GitStageDiffUtilKt.headDiffContent(project, virtualFile, gitFileStatus, string, bl);
    }

    private static final DiffContent stagedDiffContent(Project project, VirtualFile root, GitFileStatus status) throws VcsException {
        if (!GitFileStatusKt.has(status, ContentVersion.STAGED)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, status.getPath());
        if (submodule != null) {
            Hash hash = GitIndexUtil.loadStagedSubmoduleHash(submodule.getRepository(), submodule.getParent());
            Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"loadStagedSubmoduleHash(...)");
            Hash hash2 = hash;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, hash2.asString());
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
            return (DiffContent)documentContent;
        }
        VirtualFile indexFile = GitStageDiffUtilKt.stagedContentFile(project, root, status);
        VirtualFile highlightFile = !Registry.Companion.is("git.stage.navigate.to.index.file") ? status.getPath().getVirtualFile() : indexFile;
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, indexFile, highlightFile);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"create(...)");
        return diffContent;
    }

    private static final DiffContent localDiffContent(Project project, GitFileStatus status) throws VcsException {
        if (!GitFileStatusKt.has(status, ContentVersion.LOCAL)) {
            EmptyContent emptyContent = DiffContentFactory.getInstance().createEmpty();
            Intrinsics.checkNotNullExpressionValue((Object)emptyContent, (String)"createEmpty(...)");
            return (DiffContent)emptyContent;
        }
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, status.getPath());
        if (submodule != null) {
            String string = submodule.getRepository().getCurrentRevision();
            if (string == null) {
                throw new VcsException(DiffBundle.message((String)"error.cant.show.diff.cant.load.revision.content", (Object[])new Object[0]));
            }
            String revision = string;
            DocumentContent documentContent = DiffContentFactory.getInstance().create(project, revision);
            Intrinsics.checkNotNullExpressionValue((Object)documentContent, (String)"create(...)");
            return (DiffContent)documentContent;
        }
        VirtualFile virtualFile = GitFileStatusKt.path(status, ContentVersion.LOCAL).getVirtualFile();
        if (virtualFile == null) {
            Object[] objectArray = new Object[]{status.getPath()};
            throw new VcsException(GitBundle.message("stage.diff.local.content.exception.message", objectArray));
        }
        VirtualFile localFile = virtualFile;
        DiffContent diffContent = DiffContentFactory.getInstance().create(project, localFile);
        Intrinsics.checkNotNullExpressionValue((Object)diffContent, (String)"create(...)");
        return diffContent;
    }

    private static final byte[] headContentBytes(Project project, VirtualFile root, GitFileStatus status, String currentRevision) throws VcsException {
        FilePath filePath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        byte[] byArray = GitFileUtils.getFileContent(project, root, currentRevision, VcsFileUtil.relativePath((VirtualFile)root, (FilePath)filePath));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getFileContent(...)");
        return byArray;
    }

    private static final VirtualFile stagedContentFile(Project project, VirtualFile root, GitFileStatus status) throws VcsException {
        FilePath filePath = GitFileStatusKt.path(status, ContentVersion.STAGED);
        GitIndexVirtualFile gitIndexVirtualFile = GitIndexFileSystemRefresher.Companion.getInstance(project).createFile(root, filePath);
        if (gitIndexVirtualFile == null) {
            Object[] objectArray = new Object[]{status.getPath()};
            throw new VcsException(GitBundle.message("stage.diff.staged.content.exception.message", objectArray));
        }
        return gitIndexVirtualFile;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DiffRequest compareHeadWithStaged(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status, boolean forDiffPreview) {
        void it;
        FilePath filePath;
        void $this$compareHeadWithStaged_u24lambda_u242_u24lambda_u241;
        List list;
        StagedDiffRequest stagedDiffRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root);
        String headTitle = forDiffPreview ? "HEAD" : GitStageDiffUtilKt.getPresentableRevision(repository2);
        String string = GitBundle.message("stage.content.staged", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String stagedTitle = string;
        StagedDiffRequest $this$compareHeadWithStaged_u24lambda_u242 = stagedDiffRequest = new StagedDiffRequest(GitStageDiffUtilKt.headDiffContent(project, root, status, GitStageDiffUtilKt.getCurrentRevision(repository2), forDiffPreview), GitStageDiffUtilKt.stagedDiffContent(project, root, status), headTitle, stagedTitle, GitStageDiffUtilKt.getTitle(status, NodeKind.STAGED));
        boolean bl = false;
        $this$compareHeadWithStaged_u24lambda_u242.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_ACTION_TEXT, GitBundle.message("action.label.reset.staged.range", new Object[0]));
        List list2 = list = CollectionsKt.createListBuilder();
        DiffRequest diffRequest = (DiffRequest)$this$compareHeadWithStaged_u24lambda_u242;
        boolean bl2 = false;
        FilePath headPath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        $this$compareHeadWithStaged_u24lambda_u242_u24lambda_u241.add(DiffEditorTitleDetails.Companion.create(project, headPath, headTitle));
        FilePath filePath2 = filePath = GitFileStatusKt.path(status, ContentVersion.STAGED);
        Project project2 = project;
        DiffEditorTitleDetails.Companion companion = DiffEditorTitleDetails.Companion;
        void var19_19 = $this$compareHeadWithStaged_u24lambda_u242_u24lambda_u241;
        boolean bl3 = false;
        boolean bl4 = !Intrinsics.areEqual((Object)it, (Object)headPath);
        var19_19.add(companion.create(project2, (FilePath)(bl4 ? filePath : null), stagedTitle));
        DiffUtil.addTitleCustomizers((DiffRequest)diffRequest, (List)DiffEditorTitleDetailsKt.getCustomizers((List)CollectionsKt.build((List)list)));
        return (DiffRequest)stagedDiffRequest;
    }

    public static /* synthetic */ DiffRequest compareHeadWithStaged$default(Project project, VirtualFile virtualFile, GitFileStatus gitFileStatus, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        return GitStageDiffUtilKt.compareHeadWithStaged(project, virtualFile, gitFileStatus, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DiffRequest compareStagedWithLocal(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status) {
        void it;
        FilePath filePath;
        void $this$compareStagedWithLocal_u24lambda_u245_u24lambda_u244;
        List list;
        StagedDiffRequest stagedDiffRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String string = GitBundle.message("stage.content.staged", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String stagedTitle = string;
        String string2 = GitBundle.message("stage.content.local", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String localTitle = string2;
        StagedDiffRequest $this$compareStagedWithLocal_u24lambda_u245 = stagedDiffRequest = new StagedDiffRequest(GitStageDiffUtilKt.stagedDiffContent(project, root, status), GitStageDiffUtilKt.localDiffContent(project, status), stagedTitle, localTitle, GitStageDiffUtilKt.getTitle(status, NodeKind.UNSTAGED));
        boolean bl = false;
        $this$compareStagedWithLocal_u24lambda_u245.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_ACTION_TEXT, GitBundle.message("action.label.add.unstaged.range", new Object[0]));
        $this$compareStagedWithLocal_u24lambda_u245.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_ACTION_TEXT, DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]));
        List list2 = list = CollectionsKt.createListBuilder();
        DiffRequest diffRequest = (DiffRequest)$this$compareStagedWithLocal_u24lambda_u245;
        boolean bl2 = false;
        FilePath stagedPath = GitFileStatusKt.path(status, ContentVersion.STAGED);
        $this$compareStagedWithLocal_u24lambda_u245_u24lambda_u244.add(DiffEditorTitleDetails.Companion.create(project, stagedPath, stagedTitle));
        FilePath filePath2 = filePath = GitFileStatusKt.path(status, ContentVersion.LOCAL);
        Project project2 = project;
        DiffEditorTitleDetails.Companion companion = DiffEditorTitleDetails.Companion;
        void var17_17 = $this$compareStagedWithLocal_u24lambda_u245_u24lambda_u244;
        boolean bl3 = false;
        boolean bl4 = !Intrinsics.areEqual((Object)it, (Object)stagedPath);
        var17_17.add(companion.create(project2, (FilePath)(bl4 ? filePath : null), localTitle));
        DiffUtil.addTitleCustomizers((DiffRequest)diffRequest, (List)DiffEditorTitleDetailsKt.getCustomizers((List)CollectionsKt.build((List)list)));
        return (DiffRequest)stagedDiffRequest;
    }

    @NotNull
    public static final DiffRequest compareThreeVersions(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitFileStatus status, boolean forDiffPreview) {
        FilePath it;
        FilePath filePath;
        StagedDiffRequest stagedDiffRequest;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        String title = GitStageDiffUtilKt.getTitle(status);
        GitRepository repository2 = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForRootQuick(root);
        String headTitle = forDiffPreview ? "HEAD" : GitStageDiffUtilKt.getPresentableRevision(repository2);
        String string = GitBundle.message("stage.content.staged", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String stagedTitle = string;
        String string2 = GitBundle.message("stage.content.local", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String localTitle = string2;
        StagedDiffRequest $this$compareThreeVersions_u24lambda_u248 = stagedDiffRequest = new StagedDiffRequest(GitStageDiffUtilKt.headDiffContent(project, root, status, GitStageDiffUtilKt.getCurrentRevision(repository2), forDiffPreview), GitStageDiffUtilKt.stagedDiffContent(project, root, status), GitStageDiffUtilKt.localDiffContent(project, status), headTitle, stagedTitle, localTitle, title);
        boolean bl = false;
        $this$compareThreeVersions_u24lambda_u248.putUserData(DiffUserDataKeys.THREESIDE_DIFF_COLORS_MODE, DiffUserDataKeys.ThreeSideDiffColors.LEFT_TO_RIGHT);
        $this$compareThreeVersions_u24lambda_u248.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_RIGHT_TO_BASE_ACTION_TEXT, GitBundle.message("action.label.add.unstaged.range", new Object[0]));
        $this$compareThreeVersions_u24lambda_u248.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_BASE_TO_RIGHT_ACTION_TEXT, DiffBundle.message((String)"action.presentation.diff.revert.text", (Object[])new Object[0]));
        $this$compareThreeVersions_u24lambda_u248.putUserData(DiffUserDataKeysEx.VCS_DIFF_ACCEPT_LEFT_TO_BASE_ACTION_TEXT, GitBundle.message("action.label.reset.staged.range", new Object[0]));
        FilePath stagedPath = GitFileStatusKt.path(status, ContentVersion.STAGED);
        Object[] objectArray = new DiffEditorTitleDetails[3];
        FilePath filePath2 = filePath = GitFileStatusKt.path(status, ContentVersion.HEAD);
        Project project2 = project;
        DiffEditorTitleDetails.Companion companion = DiffEditorTitleDetails.Companion;
        int n = 0;
        Object[] objectArray2 = objectArray;
        DiffRequest diffRequest = (DiffRequest)$this$compareThreeVersions_u24lambda_u248;
        boolean bl2 = false;
        boolean bl3 = !Intrinsics.areEqual((Object)it, (Object)stagedPath);
        objectArray2[n] = companion.create(project2, (FilePath)(bl3 ? filePath : null), headTitle);
        objectArray[1] = DiffEditorTitleDetails.Companion.create(project, stagedPath, stagedTitle);
        it = filePath = GitFileStatusKt.path(status, ContentVersion.LOCAL);
        project2 = project;
        companion = DiffEditorTitleDetails.Companion;
        n = 2;
        objectArray2 = objectArray;
        boolean bl4 = false;
        bl3 = !Intrinsics.areEqual((Object)it, (Object)stagedPath);
        objectArray2[n] = companion.create(project2, (FilePath)(bl3 ? filePath : null), localTitle);
        DiffUtil.addTitleCustomizers((DiffRequest)diffRequest, (List)DiffEditorTitleDetailsKt.getCustomizers((List)CollectionsKt.listOf((Object[])objectArray)));
        return (DiffRequest)stagedDiffRequest;
    }

    private static final boolean has(GitFileStatusNode $this$has, ContentVersion contentVersion) {
        return GitFileStatusKt.has($this$has.getStatus(), contentVersion);
    }

    @Nls
    private static final String getTitle(GitFileStatus status, NodeKind kind) {
        String string = DiffRequestFactory.getInstance().getTitleForModification(status.getPath(), kind.origPath(status));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitleForModification(...)");
        return string;
    }

    @Nls
    private static final String getTitle(GitFileStatus status) {
        String string = DiffRequestFactory.getInstance().getTitleForModification(status.getPath(), status.getOrigPath());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitleForModification(...)");
        return string;
    }

    public static final /* synthetic */ boolean access$has(GitFileStatusNode $receiver, ContentVersion contentVersion) {
        return GitStageDiffUtilKt.has($receiver, contentVersion);
    }

    public static final /* synthetic */ String access$getTitle(GitFileStatus status, NodeKind kind) {
        return GitStageDiffUtilKt.getTitle(status, kind);
    }

    public static final /* synthetic */ byte[] access$headContentBytes(Project project, VirtualFile root, GitFileStatus status, String currentRevision) {
        return GitStageDiffUtilKt.headContentBytes(project, root, status, currentRevision);
    }

    public static final /* synthetic */ VirtualFile access$stagedContentFile(Project project, VirtualFile root, GitFileStatus status) {
        return GitStageDiffUtilKt.stagedContentFile(project, root, status);
    }

    static {
        Key key = Key.create((String)"GitStage.HeadInfo");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        HEAD_INFO = key;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[NodeKind.values().length];
            try {
                nArray[NodeKind.STAGED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeKind.UNSTAGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeKind.CONFLICTED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeKind.UNTRACKED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NodeKind.IGNORED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ContentVersion.values().length];
            try {
                nArray[ContentVersion.HEAD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContentVersion.STAGED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ContentVersion.LOCAL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

