/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.comparesegments;

import tim.prune.data.Bearing;
import tim.prune.data.DataPoint;
import tim.prune.function.comparesegments.PointData;

public class LineAndBearing {
    final PointData _fromPoint;
    final PointData _toPoint;
    final double _bearing;
    final double _distToFromPointRadians;
    final double _distAlongRadians;

    LineAndBearing(PointData pointData, PointData pointData2) {
        this._fromPoint = pointData;
        this._toPoint = pointData2;
        this._bearing = Bearing.calculateDegrees(this._fromPoint._point, pointData2._point);
        this._distToFromPointRadians = pointData._distanceToHereRadians;
        this._distAlongRadians = pointData2._distanceToHereRadians - pointData._distanceToHereRadians;
    }

    DataPoint getFromPoint() {
        return this._fromPoint._point;
    }

    DataPoint getToPoint() {
        return this._toPoint._point;
    }

    long getMilliseconds() {
        return this.getToPoint().getTimestamp().getMillisecondsSince(this.getFromPoint().getTimestamp());
    }

    double getInterpolatedSpeed(double d) {
        double d2 = this._fromPoint._speedRadiansPerSec;
        double d3 = this._toPoint._speedRadiansPerSec;
        return d2 + d * (d3 - d2);
    }
}

