/*
 * Decompiled with CFR 0.152.
 */
package ghidra.taint.model;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class TaintMark {
    private static final String SEP = ":";
    private static final String TAG_SEP = ",";
    private final String name;
    private final Set<String> tags;
    private final int hashCode;

    public static TaintMark parse(String string) {
        String[] parts = string.split(SEP);
        if (parts.length == 1) {
            return new TaintMark(parts[0], Set.of());
        }
        return new TaintMark(parts[0], Set.of(parts[1].split(TAG_SEP)));
    }

    public TaintMark(String name, Set<String> tags) {
        this.name = name;
        this.tags = Set.copyOf(tags);
        this.hashCode = Objects.hash(name, tags);
    }

    public String toString() {
        if (this.tags.isEmpty()) {
            return this.getName();
        }
        return this.getName() + SEP + this.tags.stream().collect(Collectors.joining(TAG_SEP));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaintMark)) {
            return false;
        }
        TaintMark that = (TaintMark)obj;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    public TaintMark tagged(String tag) {
        if (this.tags.contains(tag)) {
            return this;
        }
        HashSet<String> tags = new HashSet<String>(this.tags);
        tags.add(tag);
        return new TaintMark(this.name, tags);
    }
}

