/*
 * Decompiled with CFR 0.152.
 */
package mdemangler.object;

import mdemangler.MDException;
import mdemangler.MDMang;
import mdemangler.MDParsableItem;
import mdemangler.datatype.MDDataType;
import mdemangler.datatype.MDDataTypeParser;
import mdemangler.object.MDObjectBracket;
import mdemangler.object.MDObjectC;
import mdemangler.object.MDObjectCPP;
import mdemangler.object.MDObjectCatch;
import mdemangler.object.MDObjectCatchSym;
import mdemangler.object.MDObjectCatchableType;
import mdemangler.object.MDObjectCatchableTypeArray;
import mdemangler.object.MDObjectCodeView;
import mdemangler.object.MDObjectEHHandler;
import mdemangler.object.MDObjectReserved;
import mdemangler.object.MDObjectThrowInfo;
import mdemangler.object.MDObjectTryBlockTable;
import mdemangler.object.MDObjectUnwindFunclet;
import mdemangler.object.MDObjectUnwindTable;
import mdemangler.template.MDTemplateNameAndArguments;

public class MDMangObjectParser {
    public static MDParsableItem determineItemAndParse(MDMang dmang) throws MDException {
        MDParsableItem myItem = null;
        dmang.setProcessingMode(MDMang.ProcessingMode.DEFAULT_STANDARD);
        try {
            myItem = MDMangObjectParser.parse(dmang);
        }
        catch (MDException e1) {
            dmang.resetState();
            dmang.setProcessingMode(MDMang.ProcessingMode.LLVM);
            try {
                myItem = MDMangObjectParser.parse(dmang);
            }
            catch (MDException e2) {
                throw new MDException("Reason1: " + e1.getMessage().trim() + "; Reason2: " + e2.getMessage().trim());
            }
        }
        return myItem;
    }

    private static MDParsableItem parse(MDMang dmang) throws MDException {
        if (dmang.peek() == '.' && !dmang.getMangledSymbol().substring(1).contains(".")) {
            dmang.increment();
            MDDataType item = MDDataTypeParser.parseDataType(dmang, false);
            dmang.pushContext();
            item.parse();
            dmang.popContext();
            return item;
        }
        if (dmang.peek() == '?') {
            MDParsableItem item;
            if (dmang.peek(1) == '@') {
                MDObjectCodeView item2 = new MDObjectCodeView(dmang);
                dmang.pushContext();
                item2.parse();
                dmang.popContext();
                return item2;
            }
            if (dmang.peek(1) == '$') {
                item = new MDTemplateNameAndArguments(dmang);
                try {
                    dmang.pushContext();
                    item.parse();
                    dmang.popContext();
                    if (dmang.getNumCharsRemaining() == 0) {
                        return item;
                    }
                }
                catch (MDException mDException) {
                    // empty catch block
                }
                dmang.resetState();
            }
            item = new MDObjectCPP(dmang);
            dmang.pushContext();
            item.parse();
            dmang.popContext();
            return item;
        }
        if (dmang.peek() == '_' && (dmang.peek(1) == '_' || dmang.peek(1) >= 'A' && dmang.peek(1) <= 'Z')) {
            MDParsableItem item = MDMangObjectParser.parseObjectReserved(dmang);
            dmang.pushContext();
            item.parse();
            dmang.popContext();
            return item;
        }
        MDObjectC item = new MDObjectC(dmang);
        dmang.pushContext();
        item.parse();
        dmang.popContext();
        return item;
    }

    private static MDParsableItem parseObjectReserved(MDMang dmang) {
        MDObjectReserved item;
        if (dmang.positionStartsWith("__TI")) {
            dmang.increment("__TI".length());
            item = new MDObjectThrowInfo(dmang);
        } else if (dmang.positionStartsWith("_TI")) {
            dmang.increment("_TI".length());
            item = new MDObjectThrowInfo(dmang);
        } else if (dmang.positionStartsWith("__CTA")) {
            dmang.increment("__CTA".length());
            item = new MDObjectCatchableTypeArray(dmang);
        } else if (dmang.positionStartsWith("__CT")) {
            dmang.increment("__CT".length());
            item = new MDObjectCatchableType(dmang);
        } else if (dmang.positionStartsWith("_CTA")) {
            dmang.increment("_CTA".length());
            item = new MDObjectCatchableTypeArray(dmang);
        } else if (dmang.positionStartsWith("_CT")) {
            dmang.increment("_CT".length());
            item = new MDObjectCatchableType(dmang);
        } else if (dmang.positionStartsWith("__catch$")) {
            dmang.increment("__catch$".length());
            item = new MDObjectCatch(dmang);
        } else if (dmang.positionStartsWith("__catchsym$")) {
            dmang.increment("__catchsym$".length());
            item = new MDObjectCatchSym(dmang);
        } else if (dmang.positionStartsWith("__unwindfunclet$")) {
            dmang.increment("__unwindfunclet$".length());
            item = new MDObjectUnwindFunclet(dmang);
        } else if (dmang.positionStartsWith("__tryblocktable$")) {
            dmang.increment("__tryblocktable$".length());
            item = new MDObjectTryBlockTable(dmang);
        } else if (dmang.positionStartsWith("__unwindtable$")) {
            dmang.increment("__unwindtable$".length());
            item = new MDObjectUnwindTable(dmang);
        } else if (dmang.positionStartsWith("__ehhandler$")) {
            dmang.increment("__ehhandler$".length());
            item = new MDObjectEHHandler(dmang);
        } else {
            item = dmang.positionStartsWith("__m2mep@") ? new MDObjectBracket(dmang) : (dmang.positionStartsWith("__mep@") ? new MDObjectBracket(dmang) : (dmang.positionStartsWith("__t2m@") ? new MDObjectBracket(dmang) : (dmang.positionStartsWith("__unep@") ? new MDObjectBracket(dmang) : new MDObjectReserved(dmang))));
        }
        return item;
    }
}

