/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.main;

import ghidra.feature.vt.api.main.VTAssociationType;
import ghidra.feature.vt.api.main.VTMatchSet;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTScore;
import ghidra.program.model.address.Address;
import ghidra.util.SystemUtilities;

public class VTMatchInfo {
    private VTAssociationType associationType;
    private VTMatchTag tag;
    private VTScore similarityScore;
    private Address sourceAddress;
    private Address destinationAddress;
    private int sourceLength;
    private int destinationLength;
    protected final VTMatchSet matchSet;
    private VTScore confidenceScore;

    public VTMatchInfo(VTMatchSet vtMatchSet) {
        this.matchSet = vtMatchSet;
    }

    public VTMatchSet getMatchSet() {
        return this.matchSet;
    }

    public VTAssociationType getAssociationType() {
        return this.associationType;
    }

    public void setAssociationType(VTAssociationType associationType) {
        this.associationType = associationType;
    }

    public VTMatchTag getTag() {
        return this.tag;
    }

    public void setTag(VTMatchTag tag) {
        this.tag = tag;
    }

    public VTScore getSimilarityScore() {
        return this.similarityScore;
    }

    public void setSimilarityScore(VTScore score) {
        this.similarityScore = score;
    }

    public void setConfidenceScore(VTScore score) {
        this.confidenceScore = score;
    }

    public VTScore getConfidenceScore() {
        return this.confidenceScore;
    }

    public void setSourceAddress(Address sourceAddress) {
        this.sourceAddress = sourceAddress;
    }

    public void setDestinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    public int getSourceLength() {
        return this.sourceLength;
    }

    public void setSourceLength(int sourceLength) {
        this.sourceLength = sourceLength;
    }

    public int getDestinationLength() {
        return this.destinationLength;
    }

    public void setDestinationLength(int destinationLength) {
        this.destinationLength = destinationLength;
    }

    public int hashCode() {
        if (this.sourceAddress != null) {
            return (int)this.sourceAddress.getOffset();
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VTMatchInfo)) {
            return false;
        }
        VTMatchInfo other = (VTMatchInfo)obj;
        if (this.destinationLength != other.getDestinationLength()) {
            return false;
        }
        if (this.getAssociationType() != other.getAssociationType()) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.similarityScore, (Object)other.getSimilarityScore())) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.confidenceScore, (Object)other.getConfidenceScore())) {
            return false;
        }
        if (this.sourceLength != other.getSourceLength()) {
            return false;
        }
        return this.tag == other.getTag();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        double simScoreValue = this.getSimilarityScore() == null ? 0.0 : this.getSimilarityScore().getScore();
        double confScoreValue = this.getConfidenceScore() == null ? 0.0 : this.getConfidenceScore().getScore();
        buffer.append("\nMatchInfo: ");
        buffer.append("\n  Type               = " + String.valueOf((Object)this.getAssociationType()));
        buffer.append("\n  Similarity Score   = " + simScoreValue);
        buffer.append("\n  Confidence Score   = " + confScoreValue);
        buffer.append("\n  SourceAddress      = " + String.valueOf(this.getSourceAddress()));
        buffer.append("\n  DestinationAddress = " + String.valueOf(this.getDestinationAddress()));
        buffer.append("\n  SourceLength       = " + this.getSourceLength());
        buffer.append("\n  DestinationLength  = " + this.getDestinationLength());
        buffer.append("\n  Tagged             = " + String.valueOf(this.getTag()));
        return buffer.toString();
    }
}

