/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pyghidra.property;

import ghidra.pyghidra.property.BooleanJavaProperty;
import ghidra.pyghidra.property.ByteJavaProperty;
import ghidra.pyghidra.property.CharacterJavaProperty;
import ghidra.pyghidra.property.DoubleJavaProperty;
import ghidra.pyghidra.property.FloatJavaProperty;
import ghidra.pyghidra.property.IntegerJavaProperty;
import ghidra.pyghidra.property.JavaProperty;
import ghidra.pyghidra.property.LongJavaProperty;
import ghidra.pyghidra.property.ObjectJavaProperty;
import ghidra.pyghidra.property.PropertyUtils;
import ghidra.pyghidra.property.ShortJavaProperty;
import java.lang.invoke.MethodHandle;

abstract sealed class AbstractJavaProperty<T>
implements JavaProperty<T>
permits BooleanJavaProperty, ByteJavaProperty, CharacterJavaProperty, DoubleJavaProperty, FloatJavaProperty, IntegerJavaProperty, LongJavaProperty, ObjectJavaProperty, ShortJavaProperty {
    public final String field;
    private final MethodHandle getter;
    private final MethodHandle setter;

    protected AbstractJavaProperty(String field, MethodHandle getter, MethodHandle setter) {
        this.field = field;
        this.getter = getter;
        this.setter = setter;
    }

    public boolean hasGetter() {
        return this.getter != null;
    }

    public boolean hasSetter() {
        return this.setter != null;
    }

    boolean hasValidSetter() {
        Class<?> setterType;
        if (this.setter == null) {
            return false;
        }
        if (this.getter == null) {
            return true;
        }
        Class<?> getterType = PropertyUtils.boxPrimitive(this.getter.type().returnType());
        return getterType == (setterType = PropertyUtils.boxPrimitive(this.setter.type().parameterType(1)));
    }

    protected final T doGet(Object self) throws Throwable {
        return (T)this.getter.invoke(self);
    }

    @Override
    public final void fset(Object self, T value) throws Throwable {
        this.setter.invoke(self, value);
    }
}

