/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractIndirectVirtualBaseClassMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractVirtualBaseClassMsType;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.MsDataTypeComponentApplier;

public class BaseClassTypeApplier
extends MsDataTypeComponentApplier {
    public BaseClassTypeApplier(DefaultPdbApplicator applicator) throws IllegalArgumentException {
        super(applicator);
    }

    RecordNumber getBaseClassRecordNumber(AbstractMsType type) {
        if (type instanceof AbstractBaseClassMsType) {
            AbstractBaseClassMsType baseType = (AbstractBaseClassMsType)type;
            return baseType.getBaseClassRecordNumber();
        }
        if (type instanceof AbstractVirtualBaseClassMsType) {
            AbstractVirtualBaseClassMsType virtualType = (AbstractVirtualBaseClassMsType)type;
            return virtualType.getBaseClassRecordNumber();
        }
        return ((AbstractIndirectVirtualBaseClassMsType)type).getBaseClassRecordNumber();
    }

    private static AbstractMsType validateType(AbstractMsType type) throws IllegalArgumentException {
        if (!(type instanceof AbstractBaseClassMsType || type instanceof AbstractVirtualBaseClassMsType || type instanceof AbstractIndirectVirtualBaseClassMsType)) {
            throw new IllegalArgumentException("PDB Incorrectly applying " + type.getClass().getSimpleName() + " to " + BaseClassTypeApplier.class.getSimpleName());
        }
        return type;
    }
}

