/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.type;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.StringParseType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import java.math.BigInteger;

public class VectorMsType
extends AbstractMsType {
    public static final int PDB_ID = 5403;
    private RecordNumber elementTypeRecordNumber;
    private long count;
    private BigInteger size;
    private String name;

    public VectorMsType(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.elementTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
        this.count = reader.parseUnsignedIntVal();
        Numeric numeric = new Numeric(reader);
        if (!numeric.isIntegral()) {
            throw new PdbException("Expecting integral numeric");
        }
        this.size = numeric.getIntegral();
        this.name = reader.parseString(pdb, StringParseType.StringNt);
    }

    @Override
    public int getPdbId() {
        return 5403;
    }

    @Override
    public BigInteger getSize() {
        return this.size;
    }

    @Override
    public void emit(StringBuilder builder, AbstractMsType.Bind bind) {
        builder.append(String.format("vector: %s[<%s> %d]", this.name, this.pdb.getTypeRecord(this.elementTypeRecordNumber), this.count));
    }
}

