/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import java.util.HashMap;
import java.util.Map;

public class ArmSwitchTableMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4441;
    private long offsetToBaseForSwitchOffsets;
    private int sectionIndexOfBaseForSwitchOffsets;
    private EntryType switchType;
    private long offsetToTableBranchInstruction;
    private long offsetToStartOfTable;
    private int sectionIndexOfTableBranchInstruction;
    private int sectionIndexOfTable;
    private long numberOfSwitchTableEntries;

    public ArmSwitchTableMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.offsetToBaseForSwitchOffsets = reader.parseVarSizedOffset(32);
        this.sectionIndexOfBaseForSwitchOffsets = pdb.parseSegment(reader);
        this.switchType = EntryType.fromValue(reader.parseUnsignedShortVal());
        this.offsetToTableBranchInstruction = reader.parseVarSizedOffset(32);
        this.offsetToStartOfTable = reader.parseVarSizedOffset(32);
        this.sectionIndexOfTableBranchInstruction = pdb.parseSegment(reader);
        this.sectionIndexOfTable = pdb.parseSegment(reader);
        this.numberOfSwitchTableEntries = reader.parseUnsignedIntVal();
    }

    @Override
    public int getPdbId() {
        return 4441;
    }

    public EntryType getSwitchEntryType() {
        return this.switchType;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(this.getSymbolTypeName());
        builder.append(":\n");
        builder.append(String.format("   Base address:   [%04X:%08X]\n", this.sectionIndexOfBaseForSwitchOffsets, this.offsetToBaseForSwitchOffsets));
        builder.append(String.format("   Branch address: [%04X:%08X]\n", this.sectionIndexOfTableBranchInstruction, this.offsetToTableBranchInstruction));
        builder.append(String.format("   Table address:  [%04X:%08X]\n", this.sectionIndexOfTable, this.offsetToStartOfTable));
        builder.append(String.format("   Entry count = %d\n", this.numberOfSwitchTableEntries));
        builder.append("   Switch entry type = " + String.valueOf((Object)this.switchType) + "\n");
    }

    @Override
    protected String getSymbolTypeName() {
        return "ARMSWITCHTABLE";
    }

    public static enum EntryType {
        UNKNOWN("unknown return", -1),
        INT1("signed byte", 0),
        UINT1("unsigned byte", 1),
        INT2("signed two byte", 2),
        UINT2("unsigned two byte", 3),
        INT4("signed four byte", 4),
        UINT4("unsigned four byte", 5),
        POINTER("pointer", 6),
        UINT1SHL1("unsigned byte scaled by two", 7),
        UINT2SHL1("unsigned two byte scaled by two", 8),
        INT1SHL1("signed byte scaled by two", 9),
        INT2SHL1("signed two byte scaled by two", 10);

        private static final Map<Integer, EntryType> BY_VALUE;
        public final String label;
        public final int value;

        public String toString() {
            return this.label;
        }

        public static EntryType fromValue(int val) {
            return BY_VALUE.getOrDefault(val, UNKNOWN);
        }

        private EntryType(String label, int value) {
            this.label = label;
            this.value = value;
        }

        static {
            BY_VALUE = new HashMap<Integer, EntryType>();
            for (EntryType val : EntryType.values()) {
                BY_VALUE.put(val.value, val);
            }
        }
    }
}

