/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.FramePointerOmissionRecord;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageFileMachine;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageFunctionEntry;
import ghidra.app.util.bin.format.pdb2.pdbreader.ImageSectionHeader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbLog;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbNewDebugInfo;
import ghidra.app.util.bin.format.pdb2.pdbreader.RvaVaDebugHeader;
import ghidra.util.exception.CancelledException;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class DebugData {
    private AbstractPdb pdb;
    private List<Integer> debugStreams = new ArrayList<Integer>();

    private int getDebugStream(DebugType debugType) {
        int index = debugType.getValue();
        if (index < 0 || index >= this.debugStreams.size()) {
            return 65535;
        }
        return this.debugStreams.get(index);
    }

    public DebugData(AbstractPdb pdb) {
        Objects.requireNonNull(pdb, "pdb cannot be null");
        this.pdb = pdb;
    }

    public List<FramePointerOmissionRecord> getFramePointerOmissionData() throws CancelledException {
        int streamNum = this.getDebugStream(DebugType.FRAME_POINTER_OMISSION);
        if (streamNum == 65535) {
            return null;
        }
        return this.deserializeFramePointerOmissionData(streamNum);
    }

    public SortedMap<Long, Long> getOmapFromSource() throws CancelledException {
        int streamNum = this.getDebugStream(DebugType.OMAP_FROM_SOURCE);
        if (streamNum == 65535) {
            return null;
        }
        return this.deserializeOMap(streamNum);
    }

    public List<ImageSectionHeader> getImageSectionHeaders() throws CancelledException {
        int streamNum = this.getDebugStream(DebugType.SECTION_HEADER);
        if (streamNum == 65535) {
            return null;
        }
        return this.deserializeSectionHeaders(streamNum);
    }

    public Integer getXData() throws CancelledException {
        int streamNum = this.getDebugStream(DebugType.SECTION_HEADER_ORIG);
        if (streamNum == 65535) {
            return null;
        }
        return this.deserializeXData(streamNum);
    }

    public List<ImageFunctionEntry> getPData() throws CancelledException {
        int streamNum = this.getDebugStream(DebugType.SECTION_HEADER_ORIG);
        if (streamNum == 65535) {
            return null;
        }
        return this.deserializePData(streamNum);
    }

    public List<ImageSectionHeader> getImageSectionHeadersOrig() throws CancelledException {
        int streamNum = this.getDebugStream(DebugType.SECTION_HEADER_ORIG);
        if (streamNum == 65535) {
            return null;
        }
        return this.deserializeSectionHeaders(streamNum);
    }

    public void deserializeHeader(PdbByteReader reader) throws PdbException, CancelledException {
        while (reader.hasMore()) {
            this.pdb.checkCancelled();
            int debugStreamNumber = reader.parseUnsignedShortVal();
            this.debugStreams.add(debugStreamNumber);
        }
        if (this.debugStreams.size() != DebugType.values().length) {
            // empty if block
        }
    }

    @Deprecated
    public void deserialize() throws PdbException, CancelledException, IOException {
        if (this.debugStreams.isEmpty()) {
            throw new PdbException("DebugData Header had not been deserialized at the appropriate time");
        }
        block12: for (DebugType dbg : DebugType.values()) {
            int streamNum = this.getDebugStream(dbg);
            if (streamNum == 65535) continue;
            switch (dbg.ordinal()) {
                case 0: {
                    continue block12;
                }
                case 1: {
                    continue block12;
                }
                case 2: {
                    continue block12;
                }
                case 3: {
                    continue block12;
                }
                case 4: {
                    continue block12;
                }
                case 5: {
                    continue block12;
                }
                case 6: {
                    continue block12;
                }
                case 7: {
                    continue block12;
                }
                case 8: {
                    continue block12;
                }
                case 9: {
                    continue block12;
                }
            }
        }
    }

    private List<FramePointerOmissionRecord> deserializeFramePointerOmissionData(int streamNum) throws CancelledException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum);
            ArrayList<FramePointerOmissionRecord> fpOmissionData = new ArrayList<FramePointerOmissionRecord>();
            while (reader.hasMore()) {
                this.pdb.checkCancelled();
                FramePointerOmissionRecord framePointerOmissionRecord = new FramePointerOmissionRecord();
                framePointerOmissionRecord.parse(reader);
                fpOmissionData.add(framePointerOmissionRecord);
            }
            return fpOmissionData;
        }
        catch (PdbException | IOException e) {
            PdbLog.message("Returning null Debug Frame Pointer Omission Data due to problem during deserialization from stream" + streamNum + ": " + e.getMessage());
            return null;
        }
    }

    private SortedMap<Long, Long> deserializeOMap(int streamNum) throws CancelledException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum);
            TreeMap<Long, Long> omap = new TreeMap<Long, Long>();
            while (reader.hasMore()) {
                this.pdb.checkCancelled();
                long v1 = reader.parseUnsignedIntVal();
                long v2 = reader.parseUnsignedIntVal();
                omap.put(v1, v2);
            }
            return omap;
        }
        catch (PdbException | IOException e) {
            PdbLog.message("Returning null Debug OMap due to problem during deserialization from stream" + streamNum + ": " + e.getMessage());
            return null;
        }
    }

    private List<ImageSectionHeader> deserializeSectionHeaders(int streamNum) throws CancelledException {
        try {
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum);
            ArrayList<ImageSectionHeader> sectionHeaders = new ArrayList<ImageSectionHeader>();
            while (reader.hasMore()) {
                this.pdb.checkCancelled();
                ImageSectionHeader imageSectionHeader = new ImageSectionHeader(this.pdb);
                imageSectionHeader.parse(reader);
                sectionHeaders.add(imageSectionHeader);
            }
            return sectionHeaders;
        }
        catch (PdbException | IOException e) {
            PdbLog.message("Returning null Debug Image Section Headers due to problem during deserialization from stream" + streamNum + ": " + e.getMessage());
            return null;
        }
    }

    private Integer deserializeXData(int streamNum) throws CancelledException {
        try {
            long dataLength;
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum);
            int streamLength = reader.getLimit();
            RvaVaDebugHeader header = new RvaVaDebugHeader();
            header.deserialize(reader);
            if (header.getHeaderVersion() != 1L) {
                return null;
            }
            long headerLength = header.getHeaderLength();
            if (headerLength + (dataLength = header.getDataLength()) > (long)streamLength) {
                throw new PdbException("Problem parsing Debug XData");
            }
            reader.setIndex((int)headerLength);
            PdbByteReader pdbByteReader = reader.getSubPdbByteReader(reader.numRemaining());
        }
        catch (PdbException | IOException e) {
            PdbLog.message("Returning null Debug XData problem during deserialization from stream" + streamNum + ": " + e.getMessage());
            return null;
        }
        return null;
    }

    private List<ImageFunctionEntry> deserializePData(int streamNum) throws CancelledException {
        try {
            long dataLength;
            PdbByteReader reader = this.pdb.getReaderForStreamNumber(streamNum);
            ArrayList<ImageFunctionEntry> myPData = new ArrayList<ImageFunctionEntry>();
            int streamLength = reader.getLimit();
            RvaVaDebugHeader header = new RvaVaDebugHeader();
            header.deserialize(reader);
            if (header.getHeaderVersion() != 1L) {
                return myPData;
            }
            long headerLength = header.getHeaderLength();
            if (headerLength + (dataLength = header.getDataLength()) > (long)streamLength) {
                throw new PdbException("Problem parsing Debug PData");
            }
            reader.setIndex((int)headerLength);
            PdbDebugInfo debugInfo = this.pdb.getDebugInfo();
            if (debugInfo instanceof PdbNewDebugInfo) {
                PdbNewDebugInfo dbi = (PdbNewDebugInfo)debugInfo;
                ImageFileMachine machine = dbi.getMachineType();
                switch (machine) {
                    case IA64: {
                        break;
                    }
                    case AMD64: {
                        break;
                    }
                }
            }
            return myPData;
        }
        catch (PdbException | IOException e) {
            PdbLog.message("Returning null Debug PData due to problem during deserialization from stream" + streamNum + ": " + e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    void dump(Writer writer) throws IOException, CancelledException, PdbException {
        writer.write("DebugData---------------------------------------------------\n");
        this.dumpDebugStreamList(writer);
        writer.write("FramePointerOmissionData------------------------------------\n");
        List<FramePointerOmissionRecord> framePointerOmissionData = this.getFramePointerOmissionData();
        if (framePointerOmissionData != null) {
            for (FramePointerOmissionRecord framePointerOmissionRecord : framePointerOmissionData) {
                this.pdb.checkCancelled();
                framePointerOmissionRecord.dump(writer);
            }
        }
        writer.write("End FramePointerOmissionData--------------------------------\n");
        writer.write("OmapFromSource----------------------------------------------\n");
        SortedMap<Long, Long> omapFromSource = this.getOmapFromSource();
        if (omapFromSource != null) {
            int num = 0;
            for (Map.Entry<Long, Long> entry : omapFromSource.entrySet()) {
                this.pdb.checkCancelled();
                writer.write(String.format("0X%08X: 0X%012X,  0X%012X\n", num++, entry.getKey(), entry.getValue()));
            }
        }
        writer.write("End OmapFromSource------------------------------------------\n");
        writer.write("ImageSectionHeaders-----------------------------------------\n");
        List<ImageSectionHeader> imageSectionHeaders = this.getImageSectionHeaders();
        if (imageSectionHeaders != null) {
            int sectionNum = 0;
            for (ImageSectionHeader imageSectionHeader : imageSectionHeaders) {
                this.pdb.checkCancelled();
                imageSectionHeader.dump(writer, sectionNum++);
            }
        }
        writer.write("End ImageSectionHeaders-------------------------------------\n");
        writer.write("ImageSectionHeadersOrig-------------------------------------\n");
        List<ImageSectionHeader> imageSectionHeadersOrig = this.getImageSectionHeadersOrig();
        if (imageSectionHeadersOrig != null) {
            boolean bl = false;
            for (ImageSectionHeader imageSectionHeader : imageSectionHeadersOrig) {
                void var6_13;
                this.pdb.checkCancelled();
                imageSectionHeader.dump(writer, (int)(++var6_13));
            }
        }
        writer.write("End ImageSectionHeadersOrig---------------------------------\n");
        writer.write("PData-------------------------------------------------------\n");
        List<ImageFunctionEntry> list = this.getPData();
        if (list != null) {
            for (ImageFunctionEntry entry : list) {
                this.pdb.checkCancelled();
                writer.append(entry.toString());
            }
        }
        writer.write("End PData---------------------------------------------------\n");
        writer.write("End DebugData-----------------------------------------------\n");
    }

    private void dumpDebugStreamList(Writer writer) throws IOException, CancelledException {
        writer.write("StreamList--------------------------------------------------\n");
        int i = 0;
        for (int strmNumber : this.debugStreams) {
            this.pdb.checkCancelled();
            writer.write(String.format("StrmNumber[%02d]: %04x\n", i++, strmNumber));
        }
        writer.write("End StreamList----------------------------------------------\n");
    }

    public static enum DebugType {
        FRAME_POINTER_OMISSION(0),
        EXCEPTION(1),
        FIXUP(2),
        OMAP_TO_SOURCE(3),
        OMAP_FROM_SOURCE(4),
        SECTION_HEADER(5),
        TOKEN_RID_MAP(6),
        X_DATA(7),
        P_DATA(8),
        NEW_FRAME_POINTER_OMISSION(9),
        SECTION_HEADER_ORIG(10);

        private final int value;

        private DebugType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

