/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class IconCache<V>
implements Function<V, Icon> {
    Map<V, Icon> iconMap = new HashMap<V, Icon>();
    protected Function<V, String> vertexLabelFunction;
    protected Function<V, Shape> vertexShapeFunction;
    protected JLabel label = new JLabel();
    protected Map<RenderingHints.Key, Object> renderingHints = new HashMap<RenderingHints.Key, Object>();
    protected Function<V, Paint> colorFunction;
    protected Stylist<V> stylist;
    protected Decorator<V> preDecorator;
    protected Decorator<V> postDecorator;

    public static <V> Builder<V> builder(Function<V, String> vertexLabelFunction) {
        return new Builder<V>(vertexLabelFunction);
    }

    protected IconCache(Builder<V> builder) {
        this(builder.vertexLabelFunction, builder.vertexShapeFunction, builder.paintFunction, builder.stylist, builder.preDecorator, builder.postDecorator);
    }

    private IconCache(Function<V, String> vertexLabelFunction, Function<V, Shape> vertexShapeFunction, Function<V, Paint> colorFunction, Stylist<V> stylist, Decorator<V> preDecorator, Decorator<V> postDecorator) {
        this.vertexLabelFunction = vertexLabelFunction;
        this.vertexShapeFunction = vertexShapeFunction;
        this.colorFunction = colorFunction;
        this.stylist = stylist;
        this.preDecorator = preDecorator;
        this.postDecorator = postDecorator;
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    @Override
    public Icon apply(V n) {
        if (!this.iconMap.containsKey(n)) {
            this.cacheIconFor(this.label, n, this.vertexLabelFunction, this.colorFunction);
        }
        return this.iconMap.get(n);
    }

    protected void cacheIconFor(JLabel label, V vertex, Function<V, String> vertexLabelFunction, Function<V, Paint> colorFunction) {
        label.setText(vertexLabelFunction.apply(vertex));
        this.stylist.style(label, vertex, colorFunction);
        Dimension size = label.getPreferredSize();
        label.setSize(size);
        BufferedImage bufferedImage = new BufferedImage(size.width, size.height, 1);
        Graphics2D graphics = bufferedImage.createGraphics();
        graphics.setRenderingHints(this.renderingHints);
        this.preDecorator.decorate(graphics, vertex, label.getBounds(), this.vertexShapeFunction, colorFunction);
        graphics.setColor(Color.black);
        label.paint(graphics);
        this.postDecorator.decorate(graphics, vertex, label.getBounds(), this.vertexShapeFunction, colorFunction);
        graphics.dispose();
        this.iconMap.put((Icon)vertex, new ImageIcon(bufferedImage));
    }

    public static class Builder<V> {
        private Function<V, String> vertexLabelFunction;
        private Function<V, Shape> vertexShapeFunction = v -> new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0);
        private Function<V, Paint> paintFunction = v -> Color.black;
        private Stylist<V> stylist = (label, vertex, colorFunction) -> {
            label.setFont(new Font("Serif", 1, 20));
            label.setForeground(Color.black);
            label.setBackground(Color.white);
            label.setOpaque(false);
            Border lineBorder = BorderFactory.createLineBorder((Color)colorFunction.apply(vertex), 3);
            Border marginBorder = BorderFactory.createEmptyBorder(4, 4, 4, 4);
            label.setBorder(new CompoundBorder(lineBorder, marginBorder));
        };
        private Decorator<V> preDecorator = (graphics, vertex, bounds, vertexShapeFunction, colorFunction) -> {
            graphics.setColor(Color.white);
            graphics.fill(bounds);
        };
        private Decorator<V> postDecorator = (graphics, vertex, bounds, vertexShapeFunction, colorFunction) -> {};

        public Builder(Function<V, String> vertexLabelFunction) {
            this.vertexLabelFunction = vertexLabelFunction;
        }

        public Builder<V> vertexShapeFunction(Function<V, Shape> vertexShapeFunction) {
            this.vertexShapeFunction = vertexShapeFunction;
            return this;
        }

        public Builder<V> colorFunction(Function<V, Paint> paintFunction) {
            this.paintFunction = paintFunction;
            return this;
        }

        public Builder<V> stylist(Stylist<V> stylist) {
            this.stylist = stylist;
            return this;
        }

        public Builder<V> preDecorator(Decorator<V> preDecorator) {
            this.preDecorator = preDecorator;
            return this;
        }

        public Builder<V> postDecorator(Decorator<V> postDecorator) {
            this.postDecorator = postDecorator;
            return this;
        }

        public IconCache<V> build() {
            return new IconCache(this);
        }
    }

    public static interface Stylist<V> {
        public void style(JLabel var1, V var2, Function<V, Paint> var3);
    }

    public static interface Decorator<V> {
        public void decorate(Graphics2D var1, V var2, Rectangle var3, Function<V, Shape> var4, Function<V, Paint> var5);
    }
}

